/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersResponse;

public class ListReviewTemplateAnswersPublisher
implements SdkPublisher<ListReviewTemplateAnswersResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListReviewTemplateAnswersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReviewTemplateAnswersPublisher(WellArchitectedAsyncClient client, ListReviewTemplateAnswersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReviewTemplateAnswersPublisher(WellArchitectedAsyncClient client, ListReviewTemplateAnswersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReviewTemplateAnswersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReviewTemplateAnswersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListReviewTemplateAnswersResponseFetcher
    implements AsyncPageFetcher<ListReviewTemplateAnswersResponse> {
        private ListReviewTemplateAnswersResponseFetcher() {
        }

        public boolean hasNextPage(ListReviewTemplateAnswersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReviewTemplateAnswersResponse> nextPage(ListReviewTemplateAnswersResponse previousPage) {
            if (previousPage == null) {
                return ListReviewTemplateAnswersPublisher.this.client.listReviewTemplateAnswers(ListReviewTemplateAnswersPublisher.this.firstRequest);
            }
            return ListReviewTemplateAnswersPublisher.this.client.listReviewTemplateAnswers((ListReviewTemplateAnswersRequest)((Object)ListReviewTemplateAnswersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

