/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.AdditionalResourceType;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceContent;
import software.amazon.awssdk.services.wellarchitected.model.UrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalResources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdditionalResources> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AdditionalResources.getter(AdditionalResources::typeAsString)).setter(AdditionalResources.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<ChoiceContent>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Content").getter(AdditionalResources.getter(AdditionalResources::content)).setter(AdditionalResources.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChoiceContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdditionalResources.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<ChoiceContent> content;

    private AdditionalResources(BuilderImpl builder) {
        this.type = builder.type;
        this.content = builder.content;
    }

    public final AdditionalResourceType type() {
        return AdditionalResourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<ChoiceContent> content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalResources)) {
            return false;
        }
        AdditionalResources other = (AdditionalResources)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"AdditionalResources").add("Type", (Object)this.typeAsString()).add("Content", this.hasContent() ? this.content() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdditionalResources, T> g) {
        return obj -> g.apply((AdditionalResources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<ChoiceContent> content = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalResources model) {
            this.type(model.type);
            this.content(model.content);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AdditionalResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<ChoiceContent.Builder> getContent() {
            List<ChoiceContent.Builder> result = UrlsCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<ChoiceContent.BuilderImpl> content) {
            this.content = UrlsCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<ChoiceContent> content) {
            this.content = UrlsCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(ChoiceContent ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<ChoiceContent.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (ChoiceContent)((ChoiceContent.Builder)ChoiceContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AdditionalResources build() {
            return new AdditionalResources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdditionalResources> {
        public Builder type(String var1);

        public Builder type(AdditionalResourceType var1);

        public Builder content(Collection<ChoiceContent> var1);

        public Builder content(ChoiceContent ... var1);

        public Builder content(Consumer<ChoiceContent.Builder> ... var1);
    }
}

