/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse;

public class ListLensReviewsPublisher
implements SdkPublisher<ListLensReviewsResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListLensReviewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLensReviewsPublisher(WellArchitectedAsyncClient client, ListLensReviewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLensReviewsPublisher(WellArchitectedAsyncClient client, ListLensReviewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLensReviewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLensReviewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLensReviewsResponseFetcher
    implements AsyncPageFetcher<ListLensReviewsResponse> {
        private ListLensReviewsResponseFetcher() {
        }

        public boolean hasNextPage(ListLensReviewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLensReviewsResponse> nextPage(ListLensReviewsResponse previousPage) {
            if (previousPage == null) {
                return ListLensReviewsPublisher.this.client.listLensReviews(ListLensReviewsPublisher.this.firstRequest);
            }
            return ListLensReviewsPublisher.this.client.listLensReviews((ListLensReviewsRequest)((Object)ListLensReviewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

