/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsResponse;

public class ListCheckDetailsIterable
implements SdkIterable<ListCheckDetailsResponse> {
    private final WellArchitectedClient client;
    private final ListCheckDetailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCheckDetailsIterable(WellArchitectedClient client, ListCheckDetailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCheckDetailsResponseFetcher();
    }

    public Iterator<ListCheckDetailsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCheckDetailsResponseFetcher
    implements SyncPageFetcher<ListCheckDetailsResponse> {
        private ListCheckDetailsResponseFetcher() {
        }

        public boolean hasNextPage(ListCheckDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCheckDetailsResponse nextPage(ListCheckDetailsResponse previousPage) {
            if (previousPage == null) {
                return ListCheckDetailsIterable.this.client.listCheckDetails(ListCheckDetailsIterable.this.firstRequest);
            }
            return ListCheckDetailsIterable.this.client.listCheckDetails((ListCheckDetailsRequest)((Object)ListCheckDetailsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

