/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AdditionalResourceType {
    HELPFUL_RESOURCE("HELPFUL_RESOURCE"),
    IMPROVEMENT_PLAN("IMPROVEMENT_PLAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdditionalResourceType> VALUE_MAP;
    private final String value;

    private AdditionalResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdditionalResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdditionalResourceType> knownValues() {
        EnumSet<AdditionalResourceType> knownValues = EnumSet.allOf(AdditionalResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AdditionalResourceType.class, AdditionalResourceType::toString);
    }
}

