/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportResponse;

public class GetConsolidatedReportIterable
implements SdkIterable<GetConsolidatedReportResponse> {
    private final WellArchitectedClient client;
    private final GetConsolidatedReportRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetConsolidatedReportIterable(WellArchitectedClient client, GetConsolidatedReportRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetConsolidatedReportResponseFetcher();
    }

    public Iterator<GetConsolidatedReportResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetConsolidatedReportResponseFetcher
    implements SyncPageFetcher<GetConsolidatedReportResponse> {
        private GetConsolidatedReportResponseFetcher() {
        }

        public boolean hasNextPage(GetConsolidatedReportResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetConsolidatedReportResponse nextPage(GetConsolidatedReportResponse previousPage) {
            if (previousPage == null) {
                return GetConsolidatedReportIterable.this.client.getConsolidatedReport(GetConsolidatedReportIterable.this.firstRequest);
            }
            return GetConsolidatedReportIterable.this.client.getConsolidatedReport((GetConsolidatedReportRequest)((Object)GetConsolidatedReportIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

