/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.LensStatus;
import software.amazon.awssdk.services.wellarchitected.model.Question;
import software.amazon.awssdk.services.wellarchitected.model.QuestionCountsCopier;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplatePillarReviewSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplatePillarReviewSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewTemplateLensReview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewTemplateLensReview> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::lensAlias)).setter(ReviewTemplateLensReview.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::lensArn)).setter(ReviewTemplateLensReview.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensVersion").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::lensVersion)).setter(ReviewTemplateLensReview.setter(Builder::lensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()}).build();
    private static final SdkField<String> LENS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensName").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::lensName)).setter(ReviewTemplateLensReview.setter(Builder::lensName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()}).build();
    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensStatus").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::lensStatusAsString)).setter(ReviewTemplateLensReview.setter(Builder::lensStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensStatus").build()}).build();
    private static final SdkField<List<ReviewTemplatePillarReviewSummary>> PILLAR_REVIEW_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PillarReviewSummaries").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::pillarReviewSummaries)).setter(ReviewTemplateLensReview.setter(Builder::pillarReviewSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarReviewSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReviewTemplatePillarReviewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::updatedAt)).setter(ReviewTemplateLensReview.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::notes)).setter(ReviewTemplateLensReview.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Map<String, Integer>> QUESTION_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("QuestionCounts").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::questionCountsAsStrings)).setter(ReviewTemplateLensReview.setter(Builder::questionCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ReviewTemplateLensReview.getter(ReviewTemplateLensReview::nextToken)).setter(ReviewTemplateLensReview.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, LENS_ARN_FIELD, LENS_VERSION_FIELD, LENS_NAME_FIELD, LENS_STATUS_FIELD, PILLAR_REVIEW_SUMMARIES_FIELD, UPDATED_AT_FIELD, NOTES_FIELD, QUESTION_COUNTS_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lensAlias;
    private final String lensArn;
    private final String lensVersion;
    private final String lensName;
    private final String lensStatus;
    private final List<ReviewTemplatePillarReviewSummary> pillarReviewSummaries;
    private final Instant updatedAt;
    private final String notes;
    private final Map<String, Integer> questionCounts;
    private final String nextToken;

    private ReviewTemplateLensReview(BuilderImpl builder) {
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.lensVersion = builder.lensVersion;
        this.lensName = builder.lensName;
        this.lensStatus = builder.lensStatus;
        this.pillarReviewSummaries = builder.pillarReviewSummaries;
        this.updatedAt = builder.updatedAt;
        this.notes = builder.notes;
        this.questionCounts = builder.questionCounts;
        this.nextToken = builder.nextToken;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final String lensVersion() {
        return this.lensVersion;
    }

    public final String lensName() {
        return this.lensName;
    }

    public final LensStatus lensStatus() {
        return LensStatus.fromValue(this.lensStatus);
    }

    public final String lensStatusAsString() {
        return this.lensStatus;
    }

    public final boolean hasPillarReviewSummaries() {
        return this.pillarReviewSummaries != null && !(this.pillarReviewSummaries instanceof SdkAutoConstructList);
    }

    public final List<ReviewTemplatePillarReviewSummary> pillarReviewSummaries() {
        return this.pillarReviewSummaries;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String notes() {
        return this.notes;
    }

    public final Map<Question, Integer> questionCounts() {
        return QuestionCountsCopier.copyStringToEnum(this.questionCounts);
    }

    public final boolean hasQuestionCounts() {
        return this.questionCounts != null && !(this.questionCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> questionCountsAsStrings() {
        return this.questionCounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillarReviewSummaries() ? this.pillarReviewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuestionCounts() ? this.questionCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewTemplateLensReview)) {
            return false;
        }
        ReviewTemplateLensReview other = (ReviewTemplateLensReview)obj;
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.lensVersion(), other.lensVersion()) && Objects.equals(this.lensName(), other.lensName()) && Objects.equals(this.lensStatusAsString(), other.lensStatusAsString()) && this.hasPillarReviewSummaries() == other.hasPillarReviewSummaries() && Objects.equals(this.pillarReviewSummaries(), other.pillarReviewSummaries()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.notes(), other.notes()) && this.hasQuestionCounts() == other.hasQuestionCounts() && Objects.equals(this.questionCountsAsStrings(), other.questionCountsAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewTemplateLensReview").add("LensAlias", (Object)this.lensAlias()).add("LensArn", (Object)this.lensArn()).add("LensVersion", (Object)this.lensVersion()).add("LensName", (Object)this.lensName()).add("LensStatus", (Object)this.lensStatusAsString()).add("PillarReviewSummaries", this.hasPillarReviewSummaries() ? this.pillarReviewSummaries() : null).add("UpdatedAt", (Object)this.updatedAt()).add("Notes", (Object)this.notes()).add("QuestionCounts", this.hasQuestionCounts() ? this.questionCountsAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "LensVersion": {
                return Optional.ofNullable(clazz.cast(this.lensVersion()));
            }
            case "LensName": {
                return Optional.ofNullable(clazz.cast(this.lensName()));
            }
            case "LensStatus": {
                return Optional.ofNullable(clazz.cast(this.lensStatusAsString()));
            }
            case "PillarReviewSummaries": {
                return Optional.ofNullable(clazz.cast(this.pillarReviewSummaries()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "QuestionCounts": {
                return Optional.ofNullable(clazz.cast(this.questionCountsAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewTemplateLensReview, T> g) {
        return obj -> g.apply((ReviewTemplateLensReview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lensAlias;
        private String lensArn;
        private String lensVersion;
        private String lensName;
        private String lensStatus;
        private List<ReviewTemplatePillarReviewSummary> pillarReviewSummaries = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;
        private String notes;
        private Map<String, Integer> questionCounts = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewTemplateLensReview model) {
            this.lensAlias(model.lensAlias);
            this.lensArn(model.lensArn);
            this.lensVersion(model.lensVersion);
            this.lensName(model.lensName);
            this.lensStatus(model.lensStatus);
            this.pillarReviewSummaries(model.pillarReviewSummaries);
            this.updatedAt(model.updatedAt);
            this.notes(model.notes);
            this.questionCountsWithStrings(model.questionCounts);
            this.nextToken(model.nextToken);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getLensVersion() {
            return this.lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final String getLensName() {
            return this.lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final String getLensStatus() {
            return this.lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        public final Builder lensStatus(LensStatus lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        public final List<ReviewTemplatePillarReviewSummary.Builder> getPillarReviewSummaries() {
            List<ReviewTemplatePillarReviewSummary.Builder> result = ReviewTemplatePillarReviewSummariesCopier.copyToBuilder(this.pillarReviewSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPillarReviewSummaries(Collection<ReviewTemplatePillarReviewSummary.BuilderImpl> pillarReviewSummaries) {
            this.pillarReviewSummaries = ReviewTemplatePillarReviewSummariesCopier.copyFromBuilder(pillarReviewSummaries);
        }

        @Override
        public final Builder pillarReviewSummaries(Collection<ReviewTemplatePillarReviewSummary> pillarReviewSummaries) {
            this.pillarReviewSummaries = ReviewTemplatePillarReviewSummariesCopier.copy(pillarReviewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarReviewSummaries(ReviewTemplatePillarReviewSummary ... pillarReviewSummaries) {
            this.pillarReviewSummaries(Arrays.asList(pillarReviewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarReviewSummaries(Consumer<ReviewTemplatePillarReviewSummary.Builder> ... pillarReviewSummaries) {
            this.pillarReviewSummaries(Stream.of(pillarReviewSummaries).map(c -> (ReviewTemplatePillarReviewSummary)((ReviewTemplatePillarReviewSummary.Builder)ReviewTemplatePillarReviewSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, Integer> getQuestionCounts() {
            if (this.questionCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.questionCounts;
        }

        public final void setQuestionCounts(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
        }

        @Override
        public final Builder questionCountsWithStrings(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
            return this;
        }

        @Override
        public final Builder questionCounts(Map<Question, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copyEnumToString(questionCounts);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public ReviewTemplateLensReview build() {
            return new ReviewTemplateLensReview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewTemplateLensReview> {
        public Builder lensAlias(String var1);

        public Builder lensArn(String var1);

        public Builder lensVersion(String var1);

        public Builder lensName(String var1);

        public Builder lensStatus(String var1);

        public Builder lensStatus(LensStatus var1);

        public Builder pillarReviewSummaries(Collection<ReviewTemplatePillarReviewSummary> var1);

        public Builder pillarReviewSummaries(ReviewTemplatePillarReviewSummary ... var1);

        public Builder pillarReviewSummaries(Consumer<ReviewTemplatePillarReviewSummary.Builder> ... var1);

        public Builder updatedAt(Instant var1);

        public Builder notes(String var1);

        public Builder questionCountsWithStrings(Map<String, Integer> var1);

        public Builder questionCounts(Map<Question, Integer> var1);

        public Builder nextToken(String var1);
    }
}

