/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse;

public class ListLensesPublisher
implements SdkPublisher<ListLensesResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListLensesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLensesPublisher(WellArchitectedAsyncClient client, ListLensesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLensesPublisher(WellArchitectedAsyncClient client, ListLensesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLensesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLensesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLensesResponseFetcher
    implements AsyncPageFetcher<ListLensesResponse> {
        private ListLensesResponseFetcher() {
        }

        public boolean hasNextPage(ListLensesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLensesResponse> nextPage(ListLensesResponse previousPage) {
            if (previousPage == null) {
                return ListLensesPublisher.this.client.listLenses(ListLensesPublisher.this.firstRequest);
            }
            return ListLensesPublisher.this.client.listLenses((ListLensesRequest)((Object)ListLensesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

