/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse;

public class ListLensReviewsIterable
implements SdkIterable<ListLensReviewsResponse> {
    private final WellArchitectedClient client;
    private final ListLensReviewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLensReviewsIterable(WellArchitectedClient client, ListLensReviewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLensReviewsResponseFetcher();
    }

    public Iterator<ListLensReviewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLensReviewsResponseFetcher
    implements SyncPageFetcher<ListLensReviewsResponse> {
        private ListLensReviewsResponseFetcher() {
        }

        public boolean hasNextPage(ListLensReviewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLensReviewsResponse nextPage(ListLensReviewsResponse previousPage) {
            if (previousPage == null) {
                return ListLensReviewsIterable.this.client.listLensReviews(ListLensReviewsIterable.this.firstRequest);
            }
            return ListLensReviewsIterable.this.client.listLensReviews((ListLensReviewsRequest)((Object)ListLensReviewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

