/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.AddressField;
import software.amazon.awssdk.services.wafv2.model.AddressFieldsCopier;
import software.amazon.awssdk.services.wafv2.model.EmailField;
import software.amazon.awssdk.services.wafv2.model.PasswordField;
import software.amazon.awssdk.services.wafv2.model.PayloadType;
import software.amazon.awssdk.services.wafv2.model.PhoneNumberField;
import software.amazon.awssdk.services.wafv2.model.PhoneNumberFieldsCopier;
import software.amazon.awssdk.services.wafv2.model.UsernameField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestInspectionACFP
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestInspectionACFP> {
    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PayloadType").getter(RequestInspectionACFP.getter(RequestInspectionACFP::payloadTypeAsString)).setter(RequestInspectionACFP.setter(Builder::payloadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()}).build();
    private static final SdkField<UsernameField> USERNAME_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UsernameField").getter(RequestInspectionACFP.getter(RequestInspectionACFP::usernameField)).setter(RequestInspectionACFP.setter(Builder::usernameField)).constructor(UsernameField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameField").build()}).build();
    private static final SdkField<PasswordField> PASSWORD_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PasswordField").getter(RequestInspectionACFP.getter(RequestInspectionACFP::passwordField)).setter(RequestInspectionACFP.setter(Builder::passwordField)).constructor(PasswordField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordField").build()}).build();
    private static final SdkField<EmailField> EMAIL_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailField").getter(RequestInspectionACFP.getter(RequestInspectionACFP::emailField)).setter(RequestInspectionACFP.setter(Builder::emailField)).constructor(EmailField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailField").build()}).build();
    private static final SdkField<List<PhoneNumberField>> PHONE_NUMBER_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberFields").getter(RequestInspectionACFP.getter(RequestInspectionACFP::phoneNumberFields)).setter(RequestInspectionACFP.setter(Builder::phoneNumberFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddressField>> ADDRESS_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddressFields").getter(RequestInspectionACFP.getter(RequestInspectionACFP::addressFields)).setter(RequestInspectionACFP.setter(Builder::addressFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddressField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_TYPE_FIELD, USERNAME_FIELD_FIELD, PASSWORD_FIELD_FIELD, EMAIL_FIELD_FIELD, PHONE_NUMBER_FIELDS_FIELD, ADDRESS_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequestInspectionACFP.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String payloadType;
    private final UsernameField usernameField;
    private final PasswordField passwordField;
    private final EmailField emailField;
    private final List<PhoneNumberField> phoneNumberFields;
    private final List<AddressField> addressFields;

    private RequestInspectionACFP(BuilderImpl builder) {
        this.payloadType = builder.payloadType;
        this.usernameField = builder.usernameField;
        this.passwordField = builder.passwordField;
        this.emailField = builder.emailField;
        this.phoneNumberFields = builder.phoneNumberFields;
        this.addressFields = builder.addressFields;
    }

    public final PayloadType payloadType() {
        return PayloadType.fromValue(this.payloadType);
    }

    public final String payloadTypeAsString() {
        return this.payloadType;
    }

    public final UsernameField usernameField() {
        return this.usernameField;
    }

    public final PasswordField passwordField() {
        return this.passwordField;
    }

    public final EmailField emailField() {
        return this.emailField;
    }

    public final boolean hasPhoneNumberFields() {
        return this.phoneNumberFields != null && !(this.phoneNumberFields instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumberField> phoneNumberFields() {
        return this.phoneNumberFields;
    }

    public final boolean hasAddressFields() {
        return this.addressFields != null && !(this.addressFields instanceof SdkAutoConstructList);
    }

    public final List<AddressField> addressFields() {
        return this.addressFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernameField());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordField());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailField());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberFields() ? this.phoneNumberFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddressFields() ? this.addressFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestInspectionACFP)) {
            return false;
        }
        RequestInspectionACFP other = (RequestInspectionACFP)obj;
        return Objects.equals(this.payloadTypeAsString(), other.payloadTypeAsString()) && Objects.equals(this.usernameField(), other.usernameField()) && Objects.equals(this.passwordField(), other.passwordField()) && Objects.equals(this.emailField(), other.emailField()) && this.hasPhoneNumberFields() == other.hasPhoneNumberFields() && Objects.equals(this.phoneNumberFields(), other.phoneNumberFields()) && this.hasAddressFields() == other.hasAddressFields() && Objects.equals(this.addressFields(), other.addressFields());
    }

    public final String toString() {
        return ToString.builder((String)"RequestInspectionACFP").add("PayloadType", (Object)this.payloadTypeAsString()).add("UsernameField", (Object)this.usernameField()).add("PasswordField", (Object)this.passwordField()).add("EmailField", (Object)this.emailField()).add("PhoneNumberFields", this.hasPhoneNumberFields() ? this.phoneNumberFields() : null).add("AddressFields", this.hasAddressFields() ? this.addressFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PayloadType": {
                return Optional.ofNullable(clazz.cast(this.payloadTypeAsString()));
            }
            case "UsernameField": {
                return Optional.ofNullable(clazz.cast(this.usernameField()));
            }
            case "PasswordField": {
                return Optional.ofNullable(clazz.cast(this.passwordField()));
            }
            case "EmailField": {
                return Optional.ofNullable(clazz.cast(this.emailField()));
            }
            case "PhoneNumberFields": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberFields()));
            }
            case "AddressFields": {
                return Optional.ofNullable(clazz.cast(this.addressFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PayloadType", PAYLOAD_TYPE_FIELD);
        map.put("UsernameField", USERNAME_FIELD_FIELD);
        map.put("PasswordField", PASSWORD_FIELD_FIELD);
        map.put("EmailField", EMAIL_FIELD_FIELD);
        map.put("PhoneNumberFields", PHONE_NUMBER_FIELDS_FIELD);
        map.put("AddressFields", ADDRESS_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestInspectionACFP, T> g) {
        return obj -> g.apply((RequestInspectionACFP)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String payloadType;
        private UsernameField usernameField;
        private PasswordField passwordField;
        private EmailField emailField;
        private List<PhoneNumberField> phoneNumberFields = DefaultSdkAutoConstructList.getInstance();
        private List<AddressField> addressFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestInspectionACFP model) {
            this.payloadType(model.payloadType);
            this.usernameField(model.usernameField);
            this.passwordField(model.passwordField);
            this.emailField(model.emailField);
            this.phoneNumberFields(model.phoneNumberFields);
            this.addressFields(model.addressFields);
        }

        public final String getPayloadType() {
            return this.payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(PayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final UsernameField.Builder getUsernameField() {
            return this.usernameField != null ? this.usernameField.toBuilder() : null;
        }

        public final void setUsernameField(UsernameField.BuilderImpl usernameField) {
            this.usernameField = usernameField != null ? usernameField.build() : null;
        }

        @Override
        public final Builder usernameField(UsernameField usernameField) {
            this.usernameField = usernameField;
            return this;
        }

        public final PasswordField.Builder getPasswordField() {
            return this.passwordField != null ? this.passwordField.toBuilder() : null;
        }

        public final void setPasswordField(PasswordField.BuilderImpl passwordField) {
            this.passwordField = passwordField != null ? passwordField.build() : null;
        }

        @Override
        public final Builder passwordField(PasswordField passwordField) {
            this.passwordField = passwordField;
            return this;
        }

        public final EmailField.Builder getEmailField() {
            return this.emailField != null ? this.emailField.toBuilder() : null;
        }

        public final void setEmailField(EmailField.BuilderImpl emailField) {
            this.emailField = emailField != null ? emailField.build() : null;
        }

        @Override
        public final Builder emailField(EmailField emailField) {
            this.emailField = emailField;
            return this;
        }

        public final List<PhoneNumberField.Builder> getPhoneNumberFields() {
            List<PhoneNumberField.Builder> result = PhoneNumberFieldsCopier.copyToBuilder(this.phoneNumberFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumberFields(Collection<PhoneNumberField.BuilderImpl> phoneNumberFields) {
            this.phoneNumberFields = PhoneNumberFieldsCopier.copyFromBuilder(phoneNumberFields);
        }

        @Override
        public final Builder phoneNumberFields(Collection<PhoneNumberField> phoneNumberFields) {
            this.phoneNumberFields = PhoneNumberFieldsCopier.copy(phoneNumberFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberFields(PhoneNumberField ... phoneNumberFields) {
            this.phoneNumberFields(Arrays.asList(phoneNumberFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberFields(Consumer<PhoneNumberField.Builder> ... phoneNumberFields) {
            this.phoneNumberFields(Stream.of(phoneNumberFields).map(c -> (PhoneNumberField)((PhoneNumberField.Builder)PhoneNumberField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddressField.Builder> getAddressFields() {
            List<AddressField.Builder> result = AddressFieldsCopier.copyToBuilder(this.addressFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressFields(Collection<AddressField.BuilderImpl> addressFields) {
            this.addressFields = AddressFieldsCopier.copyFromBuilder(addressFields);
        }

        @Override
        public final Builder addressFields(Collection<AddressField> addressFields) {
            this.addressFields = AddressFieldsCopier.copy(addressFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressFields(AddressField ... addressFields) {
            this.addressFields(Arrays.asList(addressFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressFields(Consumer<AddressField.Builder> ... addressFields) {
            this.addressFields(Stream.of(addressFields).map(c -> (AddressField)((AddressField.Builder)AddressField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RequestInspectionACFP build() {
            return new RequestInspectionACFP(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestInspectionACFP> {
        public Builder payloadType(String var1);

        public Builder payloadType(PayloadType var1);

        public Builder usernameField(UsernameField var1);

        default public Builder usernameField(Consumer<UsernameField.Builder> usernameField) {
            return this.usernameField((UsernameField)((UsernameField.Builder)UsernameField.builder().applyMutation(usernameField)).build());
        }

        public Builder passwordField(PasswordField var1);

        default public Builder passwordField(Consumer<PasswordField.Builder> passwordField) {
            return this.passwordField((PasswordField)((PasswordField.Builder)PasswordField.builder().applyMutation(passwordField)).build());
        }

        public Builder emailField(EmailField var1);

        default public Builder emailField(Consumer<EmailField.Builder> emailField) {
            return this.emailField((EmailField)((EmailField.Builder)EmailField.builder().applyMutation(emailField)).build());
        }

        public Builder phoneNumberFields(Collection<PhoneNumberField> var1);

        public Builder phoneNumberFields(PhoneNumberField ... var1);

        public Builder phoneNumberFields(Consumer<PhoneNumberField.Builder> ... var1);

        public Builder addressFields(Collection<AddressField> var1);

        public Builder addressFields(AddressField ... var1);

        public Builder addressFields(Consumer<AddressField.Builder> ... var1);
    }
}

