/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.Scope;
import software.amazon.awssdk.services.wafv2.model.TimeWindow;
import software.amazon.awssdk.services.wafv2.model.Wafv2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSampledRequestsRequest
extends Wafv2Request
implements ToCopyableBuilder<Builder, GetSampledRequestsRequest> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAclArn").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::webAclArn)).setter(GetSampledRequestsRequest.setter(Builder::webAclArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclArn").build()}).build();
    private static final SdkField<String> RULE_METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleMetricName").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::ruleMetricName)).setter(GetSampledRequestsRequest.setter(Builder::ruleMetricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleMetricName").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::scopeAsString)).setter(GetSampledRequestsRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<TimeWindow> TIME_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeWindow").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::timeWindow)).setter(GetSampledRequestsRequest.setter(Builder::timeWindow)).constructor(TimeWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeWindow").build()}).build();
    private static final SdkField<Long> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxItems").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::maxItems)).setter(GetSampledRequestsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD, RULE_METRIC_NAME_FIELD, SCOPE_FIELD, TIME_WINDOW_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSampledRequestsRequest.memberNameToFieldInitializer();
    private final String webAclArn;
    private final String ruleMetricName;
    private final String scope;
    private final TimeWindow timeWindow;
    private final Long maxItems;

    private GetSampledRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.webAclArn = builder.webAclArn;
        this.ruleMetricName = builder.ruleMetricName;
        this.scope = builder.scope;
        this.timeWindow = builder.timeWindow;
        this.maxItems = builder.maxItems;
    }

    public final String webAclArn() {
        return this.webAclArn;
    }

    public final String ruleMetricName() {
        return this.ruleMetricName;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final TimeWindow timeWindow() {
        return this.timeWindow;
    }

    public final Long maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webAclArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleMetricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsRequest)) {
            return false;
        }
        GetSampledRequestsRequest other = (GetSampledRequestsRequest)((Object)obj);
        return Objects.equals(this.webAclArn(), other.webAclArn()) && Objects.equals(this.ruleMetricName(), other.ruleMetricName()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.timeWindow(), other.timeWindow()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"GetSampledRequestsRequest").add("WebAclArn", (Object)this.webAclArn()).add("RuleMetricName", (Object)this.ruleMetricName()).add("Scope", (Object)this.scopeAsString()).add("TimeWindow", (Object)this.timeWindow()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebAclArn": {
                return Optional.ofNullable(clazz.cast(this.webAclArn()));
            }
            case "RuleMetricName": {
                return Optional.ofNullable(clazz.cast(this.ruleMetricName()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "TimeWindow": {
                return Optional.ofNullable(clazz.cast(this.timeWindow()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WebAclArn", WEB_ACL_ARN_FIELD);
        map.put("RuleMetricName", RULE_METRIC_NAME_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("TimeWindow", TIME_WINDOW_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSampledRequestsRequest, T> g) {
        return obj -> g.apply((GetSampledRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Request.BuilderImpl
    implements Builder {
        private String webAclArn;
        private String ruleMetricName;
        private String scope;
        private TimeWindow timeWindow;
        private Long maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampledRequestsRequest model) {
            super(model);
            this.webAclArn(model.webAclArn);
            this.ruleMetricName(model.ruleMetricName);
            this.scope(model.scope);
            this.timeWindow(model.timeWindow);
            this.maxItems(model.maxItems);
        }

        public final String getWebAclArn() {
            return this.webAclArn;
        }

        public final void setWebAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
        }

        @Override
        public final Builder webAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        public final String getRuleMetricName() {
            return this.ruleMetricName;
        }

        public final void setRuleMetricName(String ruleMetricName) {
            this.ruleMetricName = ruleMetricName;
        }

        @Override
        public final Builder ruleMetricName(String ruleMetricName) {
            this.ruleMetricName = ruleMetricName;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return this.timeWindow != null ? this.timeWindow.toBuilder() : null;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final Long getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Long maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Long maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSampledRequestsRequest build() {
            return new GetSampledRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Wafv2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSampledRequestsRequest> {
        public Builder webAclArn(String var1);

        public Builder ruleMetricName(String var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder timeWindow(TimeWindow var1);

        default public Builder timeWindow(Consumer<TimeWindow.Builder> timeWindow) {
            return this.timeWindow((TimeWindow)((TimeWindow.Builder)TimeWindow.builder().applyMutation(timeWindow)).build());
        }

        public Builder maxItems(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

