/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.CustomHTTPHeader;
import software.amazon.awssdk.services.wafv2.model.CustomHTTPHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomResponse> {
    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResponseCode").getter(CustomResponse.getter(CustomResponse::responseCode)).setter(CustomResponse.setter(Builder::responseCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()}).build();
    private static final SdkField<String> CUSTOM_RESPONSE_BODY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomResponseBodyKey").getter(CustomResponse.getter(CustomResponse::customResponseBodyKey)).setter(CustomResponse.setter(Builder::customResponseBodyKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomResponseBodyKey").build()}).build();
    private static final SdkField<List<CustomHTTPHeader>> RESPONSE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResponseHeaders").getter(CustomResponse.getter(CustomResponse::responseHeaders)).setter(CustomResponse.setter(Builder::responseHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomHTTPHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_CODE_FIELD, CUSTOM_RESPONSE_BODY_KEY_FIELD, RESPONSE_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer responseCode;
    private final String customResponseBodyKey;
    private final List<CustomHTTPHeader> responseHeaders;

    private CustomResponse(BuilderImpl builder) {
        this.responseCode = builder.responseCode;
        this.customResponseBodyKey = builder.customResponseBodyKey;
        this.responseHeaders = builder.responseHeaders;
    }

    public final Integer responseCode() {
        return this.responseCode;
    }

    public final String customResponseBodyKey() {
        return this.customResponseBodyKey;
    }

    public final boolean hasResponseHeaders() {
        return this.responseHeaders != null && !(this.responseHeaders instanceof SdkAutoConstructList);
    }

    public final List<CustomHTTPHeader> responseHeaders() {
        return this.responseHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.customResponseBodyKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseHeaders() ? this.responseHeaders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomResponse)) {
            return false;
        }
        CustomResponse other = (CustomResponse)obj;
        return Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.customResponseBodyKey(), other.customResponseBodyKey()) && this.hasResponseHeaders() == other.hasResponseHeaders() && Objects.equals(this.responseHeaders(), other.responseHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"CustomResponse").add("ResponseCode", (Object)this.responseCode()).add("CustomResponseBodyKey", (Object)this.customResponseBodyKey()).add("ResponseHeaders", this.hasResponseHeaders() ? this.responseHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "CustomResponseBodyKey": {
                return Optional.ofNullable(clazz.cast(this.customResponseBodyKey()));
            }
            case "ResponseHeaders": {
                return Optional.ofNullable(clazz.cast(this.responseHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResponseCode", RESPONSE_CODE_FIELD);
        map.put("CustomResponseBodyKey", CUSTOM_RESPONSE_BODY_KEY_FIELD);
        map.put("ResponseHeaders", RESPONSE_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomResponse, T> g) {
        return obj -> g.apply((CustomResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer responseCode;
        private String customResponseBodyKey;
        private List<CustomHTTPHeader> responseHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomResponse model) {
            this.responseCode(model.responseCode);
            this.customResponseBodyKey(model.customResponseBodyKey);
            this.responseHeaders(model.responseHeaders);
        }

        public final Integer getResponseCode() {
            return this.responseCode;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final String getCustomResponseBodyKey() {
            return this.customResponseBodyKey;
        }

        public final void setCustomResponseBodyKey(String customResponseBodyKey) {
            this.customResponseBodyKey = customResponseBodyKey;
        }

        @Override
        public final Builder customResponseBodyKey(String customResponseBodyKey) {
            this.customResponseBodyKey = customResponseBodyKey;
            return this;
        }

        public final List<CustomHTTPHeader.Builder> getResponseHeaders() {
            List<CustomHTTPHeader.Builder> result = CustomHTTPHeadersCopier.copyToBuilder(this.responseHeaders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponseHeaders(Collection<CustomHTTPHeader.BuilderImpl> responseHeaders) {
            this.responseHeaders = CustomHTTPHeadersCopier.copyFromBuilder(responseHeaders);
        }

        @Override
        public final Builder responseHeaders(Collection<CustomHTTPHeader> responseHeaders) {
            this.responseHeaders = CustomHTTPHeadersCopier.copy(responseHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseHeaders(CustomHTTPHeader ... responseHeaders) {
            this.responseHeaders(Arrays.asList(responseHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseHeaders(Consumer<CustomHTTPHeader.Builder> ... responseHeaders) {
            this.responseHeaders(Stream.of(responseHeaders).map(c -> (CustomHTTPHeader)((CustomHTTPHeader.Builder)CustomHTTPHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CustomResponse build() {
            return new CustomResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomResponse> {
        public Builder responseCode(Integer var1);

        public Builder customResponseBodyKey(String var1);

        public Builder responseHeaders(Collection<CustomHTTPHeader> var1);

        public Builder responseHeaders(CustomHTTPHeader ... var1);

        public Builder responseHeaders(Consumer<CustomHTTPHeader.Builder> ... var1);
    }
}

