/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.Platform;
import software.amazon.awssdk.services.wafv2.model.Wafv2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateMobileSdkReleaseUrlRequest
extends Wafv2Request
implements ToCopyableBuilder<Builder, GenerateMobileSdkReleaseUrlRequest> {
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(GenerateMobileSdkReleaseUrlRequest.getter(GenerateMobileSdkReleaseUrlRequest::platformAsString)).setter(GenerateMobileSdkReleaseUrlRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseVersion").getter(GenerateMobileSdkReleaseUrlRequest.getter(GenerateMobileSdkReleaseUrlRequest::releaseVersion)).setter(GenerateMobileSdkReleaseUrlRequest.setter(Builder::releaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_FIELD, RELEASE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateMobileSdkReleaseUrlRequest.memberNameToFieldInitializer();
    private final String platform;
    private final String releaseVersion;

    private GenerateMobileSdkReleaseUrlRequest(BuilderImpl builder) {
        super(builder);
        this.platform = builder.platform;
        this.releaseVersion = builder.releaseVersion;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String releaseVersion() {
        return this.releaseVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMobileSdkReleaseUrlRequest)) {
            return false;
        }
        GenerateMobileSdkReleaseUrlRequest other = (GenerateMobileSdkReleaseUrlRequest)((Object)obj);
        return Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.releaseVersion(), other.releaseVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateMobileSdkReleaseUrlRequest").add("Platform", (Object)this.platformAsString()).add("ReleaseVersion", (Object)this.releaseVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "ReleaseVersion": {
                return Optional.ofNullable(clazz.cast(this.releaseVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Platform", PLATFORM_FIELD);
        map.put("ReleaseVersion", RELEASE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMobileSdkReleaseUrlRequest, T> g) {
        return obj -> g.apply((GenerateMobileSdkReleaseUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Request.BuilderImpl
    implements Builder {
        private String platform;
        private String releaseVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMobileSdkReleaseUrlRequest model) {
            super(model);
            this.platform(model.platform);
            this.releaseVersion(model.releaseVersion);
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getReleaseVersion() {
            return this.releaseVersion;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMobileSdkReleaseUrlRequest build() {
            return new GenerateMobileSdkReleaseUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Wafv2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateMobileSdkReleaseUrlRequest> {
        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder releaseVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

