/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.FieldToMatch;
import software.amazon.awssdk.services.wafv2.model.LogDestinationConfigsCopier;
import software.amazon.awssdk.services.wafv2.model.LogScope;
import software.amazon.awssdk.services.wafv2.model.LogType;
import software.amazon.awssdk.services.wafv2.model.LoggingFilter;
import software.amazon.awssdk.services.wafv2.model.RedactedFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfiguration> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(LoggingConfiguration.getter(LoggingConfiguration::resourceArn)).setter(LoggingConfiguration.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<String>> LOG_DESTINATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogDestinationConfigs").getter(LoggingConfiguration.getter(LoggingConfiguration::logDestinationConfigs)).setter(LoggingConfiguration.setter(Builder::logDestinationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FieldToMatch>> REDACTED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RedactedFields").getter(LoggingConfiguration.getter(LoggingConfiguration::redactedFields)).setter(LoggingConfiguration.setter(Builder::redactedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldToMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MANAGED_BY_FIREWALL_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManagedByFirewallManager").getter(LoggingConfiguration.getter(LoggingConfiguration::managedByFirewallManager)).setter(LoggingConfiguration.setter(Builder::managedByFirewallManager)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedByFirewallManager").build()}).build();
    private static final SdkField<LoggingFilter> LOGGING_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingFilter").getter(LoggingConfiguration.getter(LoggingConfiguration::loggingFilter)).setter(LoggingConfiguration.setter(Builder::loggingFilter)).constructor(LoggingFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingFilter").build()}).build();
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogType").getter(LoggingConfiguration.getter(LoggingConfiguration::logTypeAsString)).setter(LoggingConfiguration.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()}).build();
    private static final SdkField<String> LOG_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogScope").getter(LoggingConfiguration.getter(LoggingConfiguration::logScopeAsString)).setter(LoggingConfiguration.setter(Builder::logScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, LOG_DESTINATION_CONFIGS_FIELD, REDACTED_FIELDS_FIELD, MANAGED_BY_FIREWALL_MANAGER_FIELD, LOGGING_FILTER_FIELD, LOG_TYPE_FIELD, LOG_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoggingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final List<String> logDestinationConfigs;
    private final List<FieldToMatch> redactedFields;
    private final Boolean managedByFirewallManager;
    private final LoggingFilter loggingFilter;
    private final String logType;
    private final String logScope;

    private LoggingConfiguration(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.logDestinationConfigs = builder.logDestinationConfigs;
        this.redactedFields = builder.redactedFields;
        this.managedByFirewallManager = builder.managedByFirewallManager;
        this.loggingFilter = builder.loggingFilter;
        this.logType = builder.logType;
        this.logScope = builder.logScope;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasLogDestinationConfigs() {
        return this.logDestinationConfigs != null && !(this.logDestinationConfigs instanceof SdkAutoConstructList);
    }

    public final List<String> logDestinationConfigs() {
        return this.logDestinationConfigs;
    }

    public final boolean hasRedactedFields() {
        return this.redactedFields != null && !(this.redactedFields instanceof SdkAutoConstructList);
    }

    public final List<FieldToMatch> redactedFields() {
        return this.redactedFields;
    }

    public final Boolean managedByFirewallManager() {
        return this.managedByFirewallManager;
    }

    public final LoggingFilter loggingFilter() {
        return this.loggingFilter;
    }

    public final LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public final String logTypeAsString() {
        return this.logType;
    }

    public final LogScope logScope() {
        return LogScope.fromValue(this.logScope);
    }

    public final String logScopeAsString() {
        return this.logScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogDestinationConfigs() ? this.logDestinationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRedactedFields() ? this.redactedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByFirewallManager());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasLogDestinationConfigs() == other.hasLogDestinationConfigs() && Objects.equals(this.logDestinationConfigs(), other.logDestinationConfigs()) && this.hasRedactedFields() == other.hasRedactedFields() && Objects.equals(this.redactedFields(), other.redactedFields()) && Objects.equals(this.managedByFirewallManager(), other.managedByFirewallManager()) && Objects.equals(this.loggingFilter(), other.loggingFilter()) && Objects.equals(this.logTypeAsString(), other.logTypeAsString()) && Objects.equals(this.logScopeAsString(), other.logScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingConfiguration").add("ResourceArn", (Object)this.resourceArn()).add("LogDestinationConfigs", this.hasLogDestinationConfigs() ? this.logDestinationConfigs() : null).add("RedactedFields", this.hasRedactedFields() ? this.redactedFields() : null).add("ManagedByFirewallManager", (Object)this.managedByFirewallManager()).add("LoggingFilter", (Object)this.loggingFilter()).add("LogType", (Object)this.logTypeAsString()).add("LogScope", (Object)this.logScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "LogDestinationConfigs": {
                return Optional.ofNullable(clazz.cast(this.logDestinationConfigs()));
            }
            case "RedactedFields": {
                return Optional.ofNullable(clazz.cast(this.redactedFields()));
            }
            case "ManagedByFirewallManager": {
                return Optional.ofNullable(clazz.cast(this.managedByFirewallManager()));
            }
            case "LoggingFilter": {
                return Optional.ofNullable(clazz.cast(this.loggingFilter()));
            }
            case "LogType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
            case "LogScope": {
                return Optional.ofNullable(clazz.cast(this.logScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("LogDestinationConfigs", LOG_DESTINATION_CONFIGS_FIELD);
        map.put("RedactedFields", REDACTED_FIELDS_FIELD);
        map.put("ManagedByFirewallManager", MANAGED_BY_FIREWALL_MANAGER_FIELD);
        map.put("LoggingFilter", LOGGING_FILTER_FIELD);
        map.put("LogType", LOG_TYPE_FIELD);
        map.put("LogScope", LOG_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<String> logDestinationConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<FieldToMatch> redactedFields = DefaultSdkAutoConstructList.getInstance();
        private Boolean managedByFirewallManager;
        private LoggingFilter loggingFilter;
        private String logType;
        private String logScope;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            this.resourceArn(model.resourceArn);
            this.logDestinationConfigs(model.logDestinationConfigs);
            this.redactedFields(model.redactedFields);
            this.managedByFirewallManager(model.managedByFirewallManager);
            this.loggingFilter(model.loggingFilter);
            this.logType(model.logType);
            this.logScope(model.logScope);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Collection<String> getLogDestinationConfigs() {
            if (this.logDestinationConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logDestinationConfigs;
        }

        public final void setLogDestinationConfigs(Collection<String> logDestinationConfigs) {
            this.logDestinationConfigs = LogDestinationConfigsCopier.copy(logDestinationConfigs);
        }

        @Override
        public final Builder logDestinationConfigs(Collection<String> logDestinationConfigs) {
            this.logDestinationConfigs = LogDestinationConfigsCopier.copy(logDestinationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDestinationConfigs(String ... logDestinationConfigs) {
            this.logDestinationConfigs(Arrays.asList(logDestinationConfigs));
            return this;
        }

        public final List<FieldToMatch.Builder> getRedactedFields() {
            List<FieldToMatch.Builder> result = RedactedFieldsCopier.copyToBuilder(this.redactedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRedactedFields(Collection<FieldToMatch.BuilderImpl> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copyFromBuilder(redactedFields);
        }

        @Override
        public final Builder redactedFields(Collection<FieldToMatch> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copy(redactedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(FieldToMatch ... redactedFields) {
            this.redactedFields(Arrays.asList(redactedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(Consumer<FieldToMatch.Builder> ... redactedFields) {
            this.redactedFields(Stream.of(redactedFields).map(c -> (FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getManagedByFirewallManager() {
            return this.managedByFirewallManager;
        }

        public final void setManagedByFirewallManager(Boolean managedByFirewallManager) {
            this.managedByFirewallManager = managedByFirewallManager;
        }

        @Override
        public final Builder managedByFirewallManager(Boolean managedByFirewallManager) {
            this.managedByFirewallManager = managedByFirewallManager;
            return this;
        }

        public final LoggingFilter.Builder getLoggingFilter() {
            return this.loggingFilter != null ? this.loggingFilter.toBuilder() : null;
        }

        public final void setLoggingFilter(LoggingFilter.BuilderImpl loggingFilter) {
            this.loggingFilter = loggingFilter != null ? loggingFilter.build() : null;
        }

        @Override
        public final Builder loggingFilter(LoggingFilter loggingFilter) {
            this.loggingFilter = loggingFilter;
            return this;
        }

        public final String getLogType() {
            return this.logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getLogScope() {
            return this.logScope;
        }

        public final void setLogScope(String logScope) {
            this.logScope = logScope;
        }

        @Override
        public final Builder logScope(String logScope) {
            this.logScope = logScope;
            return this;
        }

        @Override
        public final Builder logScope(LogScope logScope) {
            this.logScope(logScope == null ? null : logScope.toString());
            return this;
        }

        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfiguration> {
        public Builder resourceArn(String var1);

        public Builder logDestinationConfigs(Collection<String> var1);

        public Builder logDestinationConfigs(String ... var1);

        public Builder redactedFields(Collection<FieldToMatch> var1);

        public Builder redactedFields(FieldToMatch ... var1);

        public Builder redactedFields(Consumer<FieldToMatch.Builder> ... var1);

        public Builder managedByFirewallManager(Boolean var1);

        public Builder loggingFilter(LoggingFilter var1);

        default public Builder loggingFilter(Consumer<LoggingFilter.Builder> loggingFilter) {
            return this.loggingFilter((LoggingFilter)((LoggingFilter.Builder)LoggingFilter.builder().applyMutation(loggingFilter)).build());
        }

        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder logScope(String var1);

        public Builder logScope(LogScope var1);
    }
}

