/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiKeyResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, CreateApiKeyResponse> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("APIKey").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::apiKey)).setter(CreateApiKeyResponse.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APIKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApiKeyResponse.memberNameToFieldInitializer();
    private final String apiKey;

    private CreateApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.apiKey = builder.apiKey;
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiKeyResponse)) {
            return false;
        }
        CreateApiKeyResponse other = (CreateApiKeyResponse)((Object)obj);
        return Objects.equals(this.apiKey(), other.apiKey());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApiKeyResponse").add("APIKey", (Object)this.apiKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "APIKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("APIKey", API_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApiKeyResponse, T> g) {
        return obj -> g.apply((CreateApiKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private String apiKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiKeyResponse model) {
            super(model);
            this.apiKey(model.apiKey);
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public CreateApiKeyResponse build() {
            return new CreateApiKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApiKeyResponse> {
        public Builder apiKey(String var1);
    }
}

