/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RuleUpdate;
import software.amazon.awssdk.services.waf.model.RuleUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRuleRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateRuleRequest> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRuleRequest.getter(UpdateRuleRequest::ruleId)).setter(UpdateRuleRequest.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRuleRequest.getter(UpdateRuleRequest::changeToken)).setter(UpdateRuleRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final SdkField<List<RuleUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateRuleRequest.getter(UpdateRuleRequest::updates)).setter(UpdateRuleRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD, CHANGE_TOKEN_FIELD, UPDATES_FIELD));
    private final String ruleId;
    private final String changeToken;
    private final List<RuleUpdate> updates;

    private UpdateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleId = builder.ruleId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<RuleUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleRequest)) {
            return false;
        }
        UpdateRuleRequest other = (UpdateRuleRequest)((Object)obj);
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRuleRequest").add("RuleId", (Object)this.ruleId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.updates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleRequest, T> g) {
        return obj -> g.apply((UpdateRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String ruleId;
        private String changeToken;
        private List<RuleUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleRequest model) {
            super(model);
            this.ruleId(model.ruleId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<RuleUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(RuleUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<RuleUpdate> updates) {
            this.updates = RuleUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RuleUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<RuleUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (RuleUpdate)((RuleUpdate.Builder)RuleUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<RuleUpdate.BuilderImpl> updates) {
            this.updates = RuleUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleRequest build() {
            return new UpdateRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRuleRequest> {
        public Builder ruleId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<RuleUpdate> var1);

        public Builder updates(RuleUpdate ... var1);

        public Builder updates(Consumer<RuleUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

