/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RuleGroupSummariesCopier;
import software.amazon.awssdk.services.waf.model.RuleGroupSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRuleGroupsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListRuleGroupsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRuleGroupsResponse.getter(ListRuleGroupsResponse::nextMarker)).setter(ListRuleGroupsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<RuleGroupSummary>> RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListRuleGroupsResponse.getter(ListRuleGroupsResponse::ruleGroups)).setter(ListRuleGroupsResponse.setter(Builder::ruleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, RULE_GROUPS_FIELD));
    private final String nextMarker;
    private final List<RuleGroupSummary> ruleGroups;

    private ListRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.ruleGroups = builder.ruleGroups;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<RuleGroupSummary> ruleGroups() {
        return this.ruleGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleGroupsResponse)) {
            return false;
        }
        ListRuleGroupsResponse other = (ListRuleGroupsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.ruleGroups(), other.ruleGroups());
    }

    public String toString() {
        return ToString.builder((String)"ListRuleGroupsResponse").add("NextMarker", (Object)this.nextMarker()).add("RuleGroups", this.ruleGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "RuleGroups": {
                return Optional.ofNullable(clazz.cast(this.ruleGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListRuleGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RuleGroupSummary> ruleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleGroupsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.ruleGroups(model.ruleGroups);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<RuleGroupSummary.Builder> getRuleGroups() {
            return this.ruleGroups != null ? (Collection)this.ruleGroups.stream().map(RuleGroupSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ruleGroups(Collection<RuleGroupSummary> ruleGroups) {
            this.ruleGroups = RuleGroupSummariesCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(RuleGroupSummary ... ruleGroups) {
            this.ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<RuleGroupSummary.Builder> ... ruleGroups) {
            this.ruleGroups(Stream.of(ruleGroups).map(c -> (RuleGroupSummary)((RuleGroupSummary.Builder)RuleGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRuleGroups(Collection<RuleGroupSummary.BuilderImpl> ruleGroups) {
            this.ruleGroups = RuleGroupSummariesCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public ListRuleGroupsResponse build() {
            return new ListRuleGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRuleGroupsResponse> {
        public Builder nextMarker(String var1);

        public Builder ruleGroups(Collection<RuleGroupSummary> var1);

        public Builder ruleGroups(RuleGroupSummary ... var1);

        public Builder ruleGroups(Consumer<RuleGroupSummary.Builder> ... var1);
    }
}

