/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.HTTPRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SampledHTTPRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SampledHTTPRequest> {
    private static final SdkField<HTTPRequest> REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SampledHTTPRequest.getter(SampledHTTPRequest::request)).setter(SampledHTTPRequest.setter(Builder::request)).constructor(HTTPRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Request").build()}).build();
    private static final SdkField<Long> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SampledHTTPRequest.getter(SampledHTTPRequest::weight)).setter(SampledHTTPRequest.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SampledHTTPRequest.getter(SampledHTTPRequest::timestamp)).setter(SampledHTTPRequest.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SampledHTTPRequest.getter(SampledHTTPRequest::action)).setter(SampledHTTPRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> RULE_WITHIN_RULE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SampledHTTPRequest.getter(SampledHTTPRequest::ruleWithinRuleGroup)).setter(SampledHTTPRequest.setter(Builder::ruleWithinRuleGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleWithinRuleGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD, WEIGHT_FIELD, TIMESTAMP_FIELD, ACTION_FIELD, RULE_WITHIN_RULE_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final HTTPRequest request;
    private final Long weight;
    private final Instant timestamp;
    private final String action;
    private final String ruleWithinRuleGroup;

    private SampledHTTPRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.weight = builder.weight;
        this.timestamp = builder.timestamp;
        this.action = builder.action;
        this.ruleWithinRuleGroup = builder.ruleWithinRuleGroup;
    }

    public HTTPRequest request() {
        return this.request;
    }

    public Long weight() {
        return this.weight;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public String action() {
        return this.action;
    }

    public String ruleWithinRuleGroup() {
        return this.ruleWithinRuleGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleWithinRuleGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampledHTTPRequest)) {
            return false;
        }
        SampledHTTPRequest other = (SampledHTTPRequest)obj;
        return Objects.equals(this.request(), other.request()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.ruleWithinRuleGroup(), other.ruleWithinRuleGroup());
    }

    public String toString() {
        return ToString.builder((String)"SampledHTTPRequest").add("Request", (Object)this.request()).add("Weight", (Object)this.weight()).add("Timestamp", (Object)this.timestamp()).add("Action", (Object)this.action()).add("RuleWithinRuleGroup", (Object)this.ruleWithinRuleGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Request": {
                return Optional.ofNullable(clazz.cast(this.request()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "RuleWithinRuleGroup": {
                return Optional.ofNullable(clazz.cast(this.ruleWithinRuleGroup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SampledHTTPRequest, T> g) {
        return obj -> g.apply((SampledHTTPRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HTTPRequest request;
        private Long weight;
        private Instant timestamp;
        private String action;
        private String ruleWithinRuleGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(SampledHTTPRequest model) {
            this.request(model.request);
            this.weight(model.weight);
            this.timestamp(model.timestamp);
            this.action(model.action);
            this.ruleWithinRuleGroup(model.ruleWithinRuleGroup);
        }

        public final HTTPRequest.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        @Override
        public final Builder request(HTTPRequest request) {
            this.request = request;
            return this;
        }

        public final void setRequest(HTTPRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        public final Long getWeight() {
            return this.weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRuleWithinRuleGroup() {
            return this.ruleWithinRuleGroup;
        }

        @Override
        public final Builder ruleWithinRuleGroup(String ruleWithinRuleGroup) {
            this.ruleWithinRuleGroup = ruleWithinRuleGroup;
            return this;
        }

        public final void setRuleWithinRuleGroup(String ruleWithinRuleGroup) {
            this.ruleWithinRuleGroup = ruleWithinRuleGroup;
        }

        public SampledHTTPRequest build() {
            return new SampledHTTPRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SampledHTTPRequest> {
        public Builder request(HTTPRequest var1);

        default public Builder request(Consumer<HTTPRequest.Builder> request) {
            return this.request((HTTPRequest)((HTTPRequest.Builder)HTTPRequest.builder().applyMutation(request)).build());
        }

        public Builder weight(Long var1);

        public Builder timestamp(Instant var1);

        public Builder action(String var1);

        public Builder ruleWithinRuleGroup(String var1);
    }
}

