/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.services.waf.model.WebACL;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWebAclResponse
extends WafResponse
implements ToCopyableBuilder<Builder, CreateWebAclResponse> {
    private static final SdkField<WebACL> WEB_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateWebAclResponse.getter(CreateWebAclResponse::webACL)).setter(CreateWebAclResponse.setter(Builder::webACL)).constructor(WebACL::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACL").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateWebAclResponse.getter(CreateWebAclResponse::changeToken)).setter(CreateWebAclResponse.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_FIELD, CHANGE_TOKEN_FIELD));
    private final WebACL webACL;
    private final String changeToken;

    private CreateWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.webACL = builder.webACL;
        this.changeToken = builder.changeToken;
    }

    public WebACL webACL() {
        return this.webACL;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACL());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebAclResponse)) {
            return false;
        }
        CreateWebAclResponse other = (CreateWebAclResponse)((Object)obj);
        return Objects.equals(this.webACL(), other.webACL()) && Objects.equals(this.changeToken(), other.changeToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateWebAclResponse").add("WebACL", (Object)this.webACL()).add("ChangeToken", (Object)this.changeToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACL": {
                return Optional.ofNullable(clazz.cast(this.webACL()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebAclResponse, T> g) {
        return obj -> g.apply((CreateWebAclResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private WebACL webACL;
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebAclResponse model) {
            super(model);
            this.webACL(model.webACL);
            this.changeToken(model.changeToken);
        }

        public final WebACL.Builder getWebACL() {
            return this.webACL != null ? this.webACL.toBuilder() : null;
        }

        @Override
        public final Builder webACL(WebACL webACL) {
            this.webACL = webACL;
            return this;
        }

        public final void setWebACL(WebACL.BuilderImpl webACL) {
            this.webACL = webACL != null ? webACL.build() : null;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public CreateWebAclResponse build() {
            return new CreateWebAclResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWebAclResponse> {
        public Builder webACL(WebACL var1);

        default public Builder webACL(Consumer<WebACL.Builder> webACL) {
            return this.webACL((WebACL)((WebACL.Builder)WebACL.builder().applyMutation(webACL)).build());
        }

        public Builder changeToken(String var1);
    }
}

