/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.services.waf.model.ByteMatchTuplesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByteMatchSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByteMatchSet> {
    private static final SdkField<String> BYTE_MATCH_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ByteMatchSet.getter(ByteMatchSet::byteMatchSetId)).setter(ByteMatchSet.setter(Builder::byteMatchSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ByteMatchSet.getter(ByteMatchSet::name)).setter(ByteMatchSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<ByteMatchTuple>> BYTE_MATCH_TUPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ByteMatchSet.getter(ByteMatchSet::byteMatchTuples)).setter(ByteMatchSet.setter(Builder::byteMatchTuples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchTuples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ByteMatchTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_MATCH_SET_ID_FIELD, NAME_FIELD, BYTE_MATCH_TUPLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String byteMatchSetId;
    private final String name;
    private final List<ByteMatchTuple> byteMatchTuples;

    private ByteMatchSet(BuilderImpl builder) {
        this.byteMatchSetId = builder.byteMatchSetId;
        this.name = builder.name;
        this.byteMatchTuples = builder.byteMatchTuples;
    }

    public String byteMatchSetId() {
        return this.byteMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public List<ByteMatchTuple> byteMatchTuples() {
        return this.byteMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.byteMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.byteMatchTuples());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSet)) {
            return false;
        }
        ByteMatchSet other = (ByteMatchSet)obj;
        return Objects.equals(this.byteMatchSetId(), other.byteMatchSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.byteMatchTuples(), other.byteMatchTuples());
    }

    public String toString() {
        return ToString.builder((String)"ByteMatchSet").add("ByteMatchSetId", (Object)this.byteMatchSetId()).add("Name", (Object)this.name()).add("ByteMatchTuples", this.byteMatchTuples()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByteMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.byteMatchSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ByteMatchTuples": {
                return Optional.ofNullable(clazz.cast(this.byteMatchTuples()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByteMatchSet, T> g) {
        return obj -> g.apply((ByteMatchSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String byteMatchSetId;
        private String name;
        private List<ByteMatchTuple> byteMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSet model) {
            this.byteMatchSetId(model.byteMatchSetId);
            this.name(model.name);
            this.byteMatchTuples(model.byteMatchTuples);
        }

        public final String getByteMatchSetId() {
            return this.byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<ByteMatchTuple.Builder> getByteMatchTuples() {
            return this.byteMatchTuples != null ? (Collection)this.byteMatchTuples.stream().map(ByteMatchTuple::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder byteMatchTuples(Collection<ByteMatchTuple> byteMatchTuples) {
            this.byteMatchTuples = ByteMatchTuplesCopier.copy(byteMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchTuples(ByteMatchTuple ... byteMatchTuples) {
            this.byteMatchTuples(Arrays.asList(byteMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchTuples(Consumer<ByteMatchTuple.Builder> ... byteMatchTuples) {
            this.byteMatchTuples(Stream.of(byteMatchTuples).map(c -> (ByteMatchTuple)((ByteMatchTuple.Builder)ByteMatchTuple.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setByteMatchTuples(Collection<ByteMatchTuple.BuilderImpl> byteMatchTuples) {
            this.byteMatchTuples = ByteMatchTuplesCopier.copyFromBuilder(byteMatchTuples);
        }

        public ByteMatchSet build() {
            return new ByteMatchSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByteMatchSet> {
        public Builder byteMatchSetId(String var1);

        public Builder name(String var1);

        public Builder byteMatchTuples(Collection<ByteMatchTuple> var1);

        public Builder byteMatchTuples(ByteMatchTuple ... var1);

        public Builder byteMatchTuples(Consumer<ByteMatchTuple.Builder> ... var1);
    }
}

