/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PositionalConstraint {
    EXACTLY("EXACTLY"),
    STARTS_WITH("STARTS_WITH"),
    ENDS_WITH("ENDS_WITH"),
    CONTAINS("CONTAINS"),
    CONTAINS_WORD("CONTAINS_WORD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PositionalConstraint> VALUE_MAP;
    private final String value;

    private PositionalConstraint(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PositionalConstraint fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PositionalConstraint> knownValues() {
        EnumSet<PositionalConstraint> knownValues = EnumSet.allOf(PositionalConstraint.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PositionalConstraint.class, PositionalConstraint::toString);
    }
}

