/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IPSetDescriptorType {
    IPV4("IPV4"),
    IPV6("IPV6"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IPSetDescriptorType> VALUE_MAP;
    private final String value;

    private IPSetDescriptorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IPSetDescriptorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IPSetDescriptorType> knownValues() {
        EnumSet<IPSetDescriptorType> knownValues = EnumSet.allOf(IPSetDescriptorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IPSetDescriptorType.class, IPSetDescriptorType::toString);
    }
}

