/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParameterExceptionReason {
    INVALID_OPTION("INVALID_OPTION"),
    ILLEGAL_COMBINATION("ILLEGAL_COMBINATION"),
    ILLEGAL_ARGUMENT("ILLEGAL_ARGUMENT"),
    INVALID_TAG_KEY("INVALID_TAG_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParameterExceptionReason> VALUE_MAP;
    private final String value;

    private ParameterExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParameterExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParameterExceptionReason> knownValues() {
        EnumSet<ParameterExceptionReason> knownValues = EnumSet.allOf(ParameterExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParameterExceptionReason.class, ParameterExceptionReason::toString);
    }
}

