/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.IPSetDescriptor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSetUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(IPSetUpdate.getter(IPSetUpdate::actionAsString)).setter(IPSetUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<IPSetDescriptor> IP_SET_DESCRIPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IPSetDescriptor").getter(IPSetUpdate.getter(IPSetUpdate::ipSetDescriptor)).setter(IPSetUpdate.setter(Builder::ipSetDescriptor)).constructor(IPSetDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetDescriptor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, IP_SET_DESCRIPTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final IPSetDescriptor ipSetDescriptor;

    private IPSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.ipSetDescriptor = builder.ipSetDescriptor;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final IPSetDescriptor ipSetDescriptor() {
        return this.ipSetDescriptor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetDescriptor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetUpdate)) {
            return false;
        }
        IPSetUpdate other = (IPSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.ipSetDescriptor(), other.ipSetDescriptor());
    }

    public final String toString() {
        return ToString.builder((String)"IPSetUpdate").add("Action", (Object)this.actionAsString()).add("IPSetDescriptor", (Object)this.ipSetDescriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "IPSetDescriptor": {
                return Optional.ofNullable(clazz.cast(this.ipSetDescriptor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPSetUpdate, T> g) {
        return obj -> g.apply((IPSetUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private IPSetDescriptor ipSetDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetUpdate model) {
            this.action(model.action);
            this.ipSetDescriptor(model.ipSetDescriptor);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final IPSetDescriptor.Builder getIpSetDescriptor() {
            return this.ipSetDescriptor != null ? this.ipSetDescriptor.toBuilder() : null;
        }

        @Override
        public final Builder ipSetDescriptor(IPSetDescriptor ipSetDescriptor) {
            this.ipSetDescriptor = ipSetDescriptor;
            return this;
        }

        public final void setIpSetDescriptor(IPSetDescriptor.BuilderImpl ipSetDescriptor) {
            this.ipSetDescriptor = ipSetDescriptor != null ? ipSetDescriptor.build() : null;
        }

        public IPSetUpdate build() {
            return new IPSetUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder ipSetDescriptor(IPSetDescriptor var1);

        default public Builder ipSetDescriptor(Consumer<IPSetDescriptor.Builder> ipSetDescriptor) {
            return this.ipSetDescriptor((IPSetDescriptor)((IPSetDescriptor.Builder)IPSetDescriptor.builder().applyMutation(ipSetDescriptor)).build());
        }
    }
}

