/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedInputItem;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedInputListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.EntitiesDefinition;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchIsAuthorizedRequest
extends VerifiedPermissionsRequest
implements ToCopyableBuilder<Builder, BatchIsAuthorizedRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(BatchIsAuthorizedRequest.getter(BatchIsAuthorizedRequest::policyStoreId)).setter(BatchIsAuthorizedRequest.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<EntitiesDefinition> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("entities").getter(BatchIsAuthorizedRequest.getter(BatchIsAuthorizedRequest::entities)).setter(BatchIsAuthorizedRequest.setter(Builder::entities)).constructor(EntitiesDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build()}).build();
    private static final SdkField<List<BatchIsAuthorizedInputItem>> REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requests").getter(BatchIsAuthorizedRequest.getter(BatchIsAuthorizedRequest::requests)).setter(BatchIsAuthorizedRequest.setter(Builder::requests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchIsAuthorizedInputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, ENTITIES_FIELD, REQUESTS_FIELD));
    private final String policyStoreId;
    private final EntitiesDefinition entities;
    private final List<BatchIsAuthorizedInputItem> requests;

    private BatchIsAuthorizedRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.entities = builder.entities;
        this.requests = builder.requests;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final EntitiesDefinition entities() {
        return this.entities;
    }

    public final boolean hasRequests() {
        return this.requests != null && !(this.requests instanceof SdkAutoConstructList);
    }

    public final List<BatchIsAuthorizedInputItem> requests() {
        return this.requests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequests() ? this.requests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchIsAuthorizedRequest)) {
            return false;
        }
        BatchIsAuthorizedRequest other = (BatchIsAuthorizedRequest)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.entities(), other.entities()) && this.hasRequests() == other.hasRequests() && Objects.equals(this.requests(), other.requests());
    }

    public final String toString() {
        return ToString.builder((String)"BatchIsAuthorizedRequest").add("PolicyStoreId", (Object)this.policyStoreId()).add("Entities", (Object)this.entities()).add("Requests", this.hasRequests() ? this.requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "requests": {
                return Optional.ofNullable(clazz.cast(this.requests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchIsAuthorizedRequest, T> g) {
        return obj -> g.apply((BatchIsAuthorizedRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsRequest.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private EntitiesDefinition entities;
        private List<BatchIsAuthorizedInputItem> requests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchIsAuthorizedRequest model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.entities(model.entities);
            this.requests(model.requests);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final EntitiesDefinition.Builder getEntities() {
            return this.entities != null ? this.entities.toBuilder() : null;
        }

        public final void setEntities(EntitiesDefinition.BuilderImpl entities) {
            this.entities = entities != null ? entities.build() : null;
        }

        @Override
        public final Builder entities(EntitiesDefinition entities) {
            this.entities = entities;
            return this;
        }

        public final List<BatchIsAuthorizedInputItem.Builder> getRequests() {
            List<BatchIsAuthorizedInputItem.Builder> result = BatchIsAuthorizedInputListCopier.copyToBuilder(this.requests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequests(Collection<BatchIsAuthorizedInputItem.BuilderImpl> requests) {
            this.requests = BatchIsAuthorizedInputListCopier.copyFromBuilder(requests);
        }

        @Override
        public final Builder requests(Collection<BatchIsAuthorizedInputItem> requests) {
            this.requests = BatchIsAuthorizedInputListCopier.copy(requests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(BatchIsAuthorizedInputItem ... requests) {
            this.requests(Arrays.asList(requests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(Consumer<BatchIsAuthorizedInputItem.Builder> ... requests) {
            this.requests(Stream.of(requests).map(c -> (BatchIsAuthorizedInputItem)((BatchIsAuthorizedInputItem.Builder)BatchIsAuthorizedInputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchIsAuthorizedRequest build() {
            return new BatchIsAuthorizedRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchIsAuthorizedRequest> {
        public Builder policyStoreId(String var1);

        public Builder entities(EntitiesDefinition var1);

        default public Builder entities(Consumer<EntitiesDefinition.Builder> entities) {
            return this.entities((EntitiesDefinition)((EntitiesDefinition.Builder)EntitiesDefinition.builder().applyMutation(entities)).build());
        }

        public Builder requests(Collection<BatchIsAuthorizedInputItem> var1);

        public Builder requests(BatchIsAuthorizedInputItem ... var1);

        public Builder requests(Consumer<BatchIsAuthorizedInputItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

