/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import org.openrewrite.ExecutionContext;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.NamingUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class SettersToBuilderV2
extends Recipe {
    @NlsRewrite.DisplayName
    public String getDisplayName() {
        return "Convert V1 setters to V2 toBuilder setters";
    }

    @NlsRewrite.Description
    public String getDescription() {
        return "Convert V1 setters to V2 toBuilder setters";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (this.isV2ModelClassSetter(method)) {
                return this.convertSetterToBuilder(method);
            }
            return method;
        }

        private boolean isV2ModelClassSetter(J.MethodInvocation method) {
            return SdkTypeUtils.isV2ModelClass(method.getType()) && method.getArguments().size() == 1 && NamingUtils.isSetter(method.getSimpleName());
        }

        private J convertSetterToBuilder(J.MethodInvocation method) {
            String v2Method = String.format("#{any()} = #{any()}.toBuilder().%s(#{any()}).build()", NamingUtils.removeSet(method.getSimpleName()));
            return JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getSelect(), method.getArguments().get(0)});
        }
    }
}

