/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.IdentifierUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class S3StreamingResponseToV2
extends Recipe {
    private static final JavaType.FullyQualified S3_OBJECT_TYPE = SdkTypeUtils.fullyQualified("com.amazonaws.services.s3.model.S3Object");
    private static final JavaType.FullyQualified S3_GET_OBJECT_RESPONSE_TYPE = SdkTypeUtils.fullyQualified("software.amazon.awssdk.services.s3.model.GetObjectResponse");
    private static final JavaType.FullyQualified RESPONSE_INPUT_STREAM_TYPE = SdkTypeUtils.fullyQualified("software.amazon.awssdk.core.ResponseInputStream");
    private static final MethodMatcher GET_OBJECT_CONTENT = new MethodMatcher("com.amazonaws.services.s3.model.S3Object getObjectContent()");
    private static final MethodMatcher OBJECT_INPUT_STREAM_METHOD = new MethodMatcher("com.amazonaws.services.s3.model.S3ObjectInputStream *(..)");

    public String getDisplayName() {
        return "V1 S3Object to V2";
    }

    public String getDescription() {
        return "Transform usage of V1 S3Object to V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends JavaVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
            if (TypeUtils.isAssignableTo((JavaType)S3_OBJECT_TYPE, (JavaType)multiVariable.getType())) {
                JavaType.Parameterized newType = new JavaType.Parameterized(null, RESPONSE_INPUT_STREAM_TYPE, Collections.singletonList(S3_GET_OBJECT_RESPONSE_TYPE));
                this.maybeAddS3ResponseImports();
                multiVariable = multiVariable.withType((JavaType)newType).withTypeExpression((TypeTree)IdentifierUtils.makeId(IdentifierUtils.simpleName(newType), (JavaType)newType));
                List variables = multiVariable.getVariables().stream().map(nv -> nv.withType((JavaType)newType)).collect(Collectors.toList());
                multiVariable = multiVariable.withVariables(variables);
            }
            multiVariable = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)executionContext).cast();
            return multiVariable;
        }

        private void maybeAddS3ResponseImports() {
            this.maybeAddImport(RESPONSE_INPUT_STREAM_TYPE);
            this.maybeAddImport(S3_GET_OBJECT_RESPONSE_TYPE.getFullyQualifiedName(), null, false);
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            Expression select = (method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext).cast()).getSelect();
            if (select == null) {
                return method;
            }
            if (GET_OBJECT_CONTENT.matches((MethodCall)method)) {
                return select.withPrefix(method.getPrefix());
            }
            JavaType.Method methodType = method.getMethodType();
            if (methodType == null) {
                return method;
            }
            if (!TypeUtils.isAssignableTo((JavaType)S3_OBJECT_TYPE, (JavaType)methodType.getDeclaringType())) {
                return method;
            }
            if (Visitor.isObjectContentMethod(method)) {
                method = method.withMethodType(methodType.withDeclaringType(RESPONSE_INPUT_STREAM_TYPE));
                return method;
            }
            JavaType.Method responseGetterType = new JavaType.Method(null, 0L, RESPONSE_INPUT_STREAM_TYPE, "response", (JavaType)S3_GET_OBJECT_RESPONSE_TYPE, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            J.Identifier responseGetterId = IdentifierUtils.makeId("response", (JavaType)responseGetterType);
            J.MethodInvocation getResponse = new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)select), null, responseGetterId, JContainer.empty(), responseGetterType);
            methodType = methodType.withDeclaringType(S3_GET_OBJECT_RESPONSE_TYPE);
            method = method.withSelect((Expression)getResponse).withName(method.getName().withType((JavaType)methodType)).withMethodType(methodType);
            return method;
        }

        private static boolean isObjectContentMethod(J.MethodInvocation method) {
            Expression select = method.getSelect();
            if (select == null || !TypeUtils.isAssignableTo((JavaType)S3_OBJECT_TYPE, (JavaType)select.getType())) {
                return false;
            }
            return OBJECT_INPUT_STREAM_METHOD.matches((MethodCall)method);
        }
    }
}

