/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.NamingUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class V1GetterToV2
extends Recipe {
    public String getDisplayName() {
        return "V1 Getter to V2";
    }

    public String getDescription() {
        return "Transforms V1 getter to fluent getter in V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new V1GetterToV2Visitor();
    }

    private static class V1GetterToV2Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private V1GetterToV2Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            JavaType.Method methodType = (method = super.visitMethodInvocation(method, (Object)executionContext)).getMethodType();
            if (methodType == null) {
                return method;
            }
            String methodName = method.getSimpleName();
            JavaType.FullyQualified fullyQualified = methodType.getDeclaringType();
            if (!V1GetterToV2Visitor.shouldChangeGetter(fullyQualified)) {
                return method;
            }
            if (NamingUtils.isGetter(methodName)) {
                methodName = NamingUtils.removeGet(methodName);
            }
            methodType = methodType.withName(methodName);
            method = method.withName(method.getName().withSimpleName(methodName).withType((JavaType)methodType)).withMethodType(methodType);
            return method;
        }

        private static boolean shouldChangeGetter(JavaType.FullyQualified selectType) {
            return SdkTypeUtils.isV2ModelClass((JavaType)selectType);
        }
    }
}

