/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.v2migration.internal.utils.IdentifierUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class HttpSettingsToHttpClient
extends Recipe {
    private static final Logger log = Logger.loggerFor(HttpSettingsToHttpClient.class);
    private static final String CONFIG_VAR_TO_HTTP_SETTINGS_KEY = "software.amazon.awssdk.migration.variableReference";
    private static final String CONFIG_METHOD_TO_HTTP_SETTINGS_KEY = "software.amazon.awssdk.migration.configReference";
    private static final String OVERRIDE_CONFIG_BUILDER_HTTP_SETTINGS_CURSOR = "clientOverrideConfigBuilderHttpSettingsCursor";
    private static final Set<String> HTTP_SETTING_METHOD_NAMES = new HashSet<String>(Arrays.asList("connectionTimeout", "connectionTimeToLive", "connectionMaxIdleTime", "tcpKeepAlive", "connectionTtl", "socketTimeout", "maxConnections"));

    public String getDisplayName() {
        return "Move HTTP settings from the ClientOverrideConfiguration to ApacheHttpClient for sync and NettyNioAsyncHttpClient for async";
    }

    public String getDescription() {
        return "Move HTTP settings from the ClientOverrideConfiguration to ApacheHttpClient for sync SDK client and NettyNioAsyncHttpClient for async SDK client.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MoveHttpSettingsVisitor();
    }

    private static final class MoveHttpSettingsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MoveHttpSettingsVisitor() {
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
            JavaType type = (variable = super.visitVariable(variable, (Object)executionContext)).getType();
            if (!MoveHttpSettingsVisitor.isClientOverrideConfigurationType(type)) {
                return variable;
            }
            Expression initializer = variable.getInitializer();
            if (initializer instanceof J.MethodInvocation) {
                this.saveHttpSettingsInExecutionContextIfNeeded(executionContext, HttpSettingsToHttpClient.CONFIG_VAR_TO_HTTP_SETTINGS_KEY, variable.getSimpleName());
            }
            return variable;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            JavaType.Method methodType = (method = super.visitMethodDeclaration(method, (Object)executionContext)).getMethodType();
            if (methodType == null) {
                return method;
            }
            if (!MoveHttpSettingsVisitor.returnClientOverrideConfiguration(methodType)) {
                return method;
            }
            this.saveHttpSettingsInExecutionContextIfNeeded(executionContext, HttpSettingsToHttpClient.CONFIG_METHOD_TO_HTTP_SETTINGS_KEY, method.getSimpleName());
            return method;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation originalMethod, ExecutionContext executionContext) {
            J.MethodInvocation method = super.visitMethodInvocation(originalMethod, (Object)executionContext);
            if (MoveHttpSettingsVisitor.isClientOverrideConfigurationBuilder(method)) {
                return this.handleClientOverrideConfiguration(originalMethod, method, executionContext);
            }
            if (MoveHttpSettingsVisitor.isSdkClientBuilder(method)) {
                return this.configureHttpClientBuilder(originalMethod, method, executionContext);
            }
            return method;
        }

        private void saveHttpSettingsInExecutionContextIfNeeded(ExecutionContext executionContext, String configVarToHttpSettingsKey, String variable) {
            Map httpSettings = (Map)this.getCursor().getMessage(HttpSettingsToHttpClient.OVERRIDE_CONFIG_BUILDER_HTTP_SETTINGS_CURSOR, new HashMap());
            Map variableToHttpSettings = (Map)executionContext.getMessage(configVarToHttpSettingsKey, new HashMap());
            variableToHttpSettings.put(variable, httpSettings);
            executionContext.putMessage(configVarToHttpSettingsKey, (Object)variableToHttpSettings);
        }

        private static boolean isClientOverrideConfigurationType(JavaType type) {
            return Optional.ofNullable(TypeUtils.asFullyQualified((JavaType)type)).filter(t -> t.isAssignableTo(ClientOverrideConfiguration.class.getCanonicalName())).isPresent();
        }

        private static boolean isSdkClientBuilder(J.MethodInvocation method) {
            return Optional.ofNullable(method.getMethodType()).map(mt -> mt.getDeclaringType()).filter(t -> SdkTypeUtils.isV2ClientClass((JavaType)t)).isPresent();
        }

        private static boolean returnClientOverrideConfiguration(JavaType.Method methodType) {
            if (methodType == null) {
                return false;
            }
            return MoveHttpSettingsVisitor.isClientOverrideConfigurationType(methodType.getReturnType());
        }

        private static boolean isClientOverrideConfigurationBuilder(J.MethodInvocation method) {
            return Optional.ofNullable(method.getMethodType()).map(mt -> mt.getDeclaringType()).filter(t -> t.isAssignableTo(ClientOverrideConfiguration.class.getCanonicalName())).isPresent();
        }

        private J.MethodInvocation configureHttpClientBuilder(J.MethodInvocation originalMethod, J.MethodInvocation method, ExecutionContext executionContext) {
            JavaType.Method methodType = method.getMethodType();
            if (methodType == null) {
                return method;
            }
            if (method.getSimpleName().equals("overrideConfiguration")) {
                return this.addHttpClientBuilderIfNeeded((Pair<J.MethodInvocation, J.MethodInvocation>)Pair.of((Object)originalMethod, (Object)method), executionContext);
            }
            return method;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull J.MethodInvocation addHttpClientBuilderIfNeeded(Pair<J.MethodInvocation, J.MethodInvocation> methods, ExecutionContext executionContext) {
            J.MethodInvocation method = (J.MethodInvocation)methods.right();
            Expression expression = (Expression)method.getArguments().get(0);
            if (expression instanceof J.Identifier) {
                J.Identifier id = (J.Identifier)expression;
                Map configToHttpSettings = (Map)executionContext.getMessage(HttpSettingsToHttpClient.CONFIG_VAR_TO_HTTP_SETTINGS_KEY);
                return this.addHttpClientBuilderIfNeeded(methods, configToHttpSettings, id.getSimpleName(), executionContext);
            }
            if (expression instanceof J.MethodInvocation) {
                J.MethodInvocation methodInvocation = (J.MethodInvocation)expression;
                String methodInvocationName = methodInvocation.getName().getSimpleName();
                Map configToHttpSettings = (Map)executionContext.getMessage(HttpSettingsToHttpClient.CONFIG_METHOD_TO_HTTP_SETTINGS_KEY);
                return this.addHttpClientBuilderIfNeeded(methods, configToHttpSettings, methodInvocationName, executionContext);
            }
            return method;
        }

        private J.MethodInvocation addHttpClientBuilderIfNeeded(Pair<J.MethodInvocation, J.MethodInvocation> methods, Map<String, Map<String, Expression>> configToHttpSettings, String configKey, ExecutionContext executionContext) {
            J.MethodInvocation selectInvoke;
            J.MethodInvocation method = (J.MethodInvocation)methods.right();
            if (CollectionUtils.isNullOrEmpty(configToHttpSettings) || !configToHttpSettings.containsKey(configKey)) {
                return method;
            }
            Map<String, Expression> httpSettings = configToHttpSettings.get(configKey);
            JavaType.FullyQualified classType = Optional.ofNullable(method.getMethodType()).map(JavaType.Method::getDeclaringType).orElse(null);
            if (classType == null) {
                return method;
            }
            JavaType.FullyQualified builderType = SdkTypeUtils.v2Builder(classType);
            Expression expressionBeforeOverrideConfiguration = method.getSelect();
            if (expressionBeforeOverrideConfiguration == null || !(expressionBeforeOverrideConfiguration instanceof J.MethodInvocation) && !(expressionBeforeOverrideConfiguration instanceof J.Identifier)) {
                return method;
            }
            if (expressionBeforeOverrideConfiguration instanceof J.MethodInvocation && (selectInvoke = (J.MethodInvocation)expressionBeforeOverrideConfiguration).getSimpleName().equals("httpClientBuilder")) {
                return method;
            }
            Space space = expressionBeforeOverrideConfiguration instanceof J.MethodInvocation ? Space.format((String)"\n") : expressionBeforeOverrideConfiguration.getPrefix();
            Pair<Class, Class> httpClientClassNamePair = this.httpClientClassNamePair(classType);
            ArrayList<JavaType> parametersTypes = new ArrayList<JavaType>();
            parametersTypes.add(JavaType.buildType((String)((Class)httpClientClassNamePair.right()).getCanonicalName()));
            J.Identifier httpClientBuilderName = IdentifierUtils.makeId("httpClientBuilder", (JavaType)builderType);
            JavaType.Method httpClientBuilderMethod = new JavaType.Method(null, 0L, builderType, "httpClientBuilder", (JavaType)builderType, Collections.emptyList(), parametersTypes, Collections.emptyList(), Collections.emptyList());
            J.MethodInvocation httpClientBuilderMethodInvoke = new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)expressionBeforeOverrideConfiguration, space, Markers.EMPTY), null, httpClientBuilderName, this.httpClientBuilderInvoke(httpSettings, httpClientClassNamePair), httpClientBuilderMethod);
            method = method.withSelect((Expression)httpClientBuilderMethodInvoke);
            this.maybeAddImport(((Class)httpClientClassNamePair.left()).getCanonicalName());
            return (J.MethodInvocation)this.maybeAutoFormat((J)((J.MethodInvocation)methods.left()), (J)method, executionContext);
        }

        private Pair<Class, Class> httpClientClassNamePair(JavaType.FullyQualified classType) {
            Pair httpClientClassNamePair = !classType.getClassName().contains("Async") ? Pair.of(ApacheHttpClient.class, ApacheHttpClient.Builder.class) : Pair.of(NettyNioAsyncHttpClient.class, NettyNioAsyncHttpClient.Builder.class);
            return httpClientClassNamePair;
        }

        private JContainer<Expression> httpClientBuilderInvoke(Map<String, Expression> httpSettings, Pair<Class, Class> httpClientClassNamePair) {
            Class httpClientClassName = (Class)httpClientClassNamePair.left();
            Class httpClientBuilderClassName = (Class)httpClientClassNamePair.right();
            JavaType.FullyQualified httpClientType = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)httpClientClassName.getCanonicalName()));
            JavaType.FullyQualified httpClientBuilderType = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)httpClientBuilderClassName.getCanonicalName()));
            JavaType.Method httpClientBuilder = new JavaType.Method(null, 0L, httpClientType, "builder", (JavaType)httpClientBuilderType, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            J.Identifier httpClient = IdentifierUtils.makeId(httpClientClassName.getSimpleName(), (JavaType)httpClientType);
            J.Identifier httpClientBuilderName = IdentifierUtils.makeId("builder", (JavaType)httpClientBuilderType);
            J.MethodInvocation httpClientBuilderMethodInvoke = new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)httpClient), null, httpClientBuilderName, JContainer.empty(), httpClientBuilder);
            for (Map.Entry<String, Expression> entry : httpSettings.entrySet()) {
                httpClientBuilderMethodInvoke = MoveHttpSettingsVisitor.invokeHttpSetting(entry, httpClientBuilderType, httpClientBuilderMethodInvoke);
            }
            return JContainer.build(Arrays.asList(JRightPadded.build((Object)httpClientBuilderMethodInvoke)));
        }

        private static // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull J.MethodInvocation invokeHttpSetting(Map.Entry<String, Expression> entry, JavaType.FullyQualified httpClientBuilderType, J.MethodInvocation httpClientBuilderMethodInvoke) {
            String settingName = entry.getKey();
            Expression value = entry.getValue();
            J.Identifier settingBuilderName = IdentifierUtils.makeId(settingName, (JavaType)httpClientBuilderType);
            List<JavaType> parametersTypes = Collections.singletonList(value.getType());
            JavaType.Method settingMethod = new JavaType.Method(null, 0L, httpClientBuilderType, settingName, (JavaType)httpClientBuilderType, Collections.emptyList(), parametersTypes, Collections.emptyList(), Collections.emptyList());
            JContainer argument = JContainer.build(Arrays.asList(JRightPadded.build((Object)value)));
            J.MethodInvocation settingsInvoke = new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)httpClientBuilderMethodInvoke, Space.format((String)"\n"), Markers.EMPTY), null, settingBuilderName, argument, settingMethod);
            return settingsInvoke;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull J.MethodInvocation handleClientOverrideConfiguration(J.MethodInvocation originalMethod, J.MethodInvocation method, ExecutionContext executionContext) {
            Expression methodSelectExpression = method.getSelect();
            if (methodSelectExpression == null || !(methodSelectExpression instanceof J.MethodInvocation)) {
                return method;
            }
            J.MethodInvocation selectInvoke = (J.MethodInvocation)methodSelectExpression;
            String selectMethodName = selectInvoke.getSimpleName();
            if (!HTTP_SETTING_METHOD_NAMES.contains(selectMethodName)) {
                return method;
            }
            if (!(selectInvoke.getSelect() instanceof J.MethodInvocation)) {
                return method;
            }
            this.addHttpSettingsToClientOverrideConfigCursor(selectMethodName, selectInvoke);
            J.MethodInvocation selectInvokeSelect = (J.MethodInvocation)selectInvoke.getSelect();
            method = method.withSelect((Expression)selectInvokeSelect);
            if (method.getSimpleName().equals("build")) {
                method = method.withPrefix(Space.SINGLE_SPACE);
            }
            return (J.MethodInvocation)this.maybeAutoFormat((J)originalMethod, (J)method, executionContext);
        }

        private void addHttpSettingsToClientOverrideConfigCursor(String selectMethodName, J.MethodInvocation selectInvoke) {
            Cursor parentCursor = this.getCursor();
            try {
                parentCursor = this.getCursor().dropParentUntil(parent -> MoveHttpSettingsVisitor.isClientOverrideConfigurationNamedVariableType(parent));
            }
            catch (Exception e) {
                log.debug(() -> "Cannot find named variable type", (Throwable)e);
            }
            try {
                parentCursor = this.getCursor().dropParentUntil(parent -> parent instanceof J.MethodDeclaration && MoveHttpSettingsVisitor.returnClientOverrideConfiguration(((J.MethodDeclaration)parent).getMethodType()));
            }
            catch (Exception e) {
                log.debug(() -> "Cannot find method declaration type", (Throwable)e);
            }
            Map httpSettings = (Map)parentCursor.getMessage(HttpSettingsToHttpClient.OVERRIDE_CONFIG_BUILDER_HTTP_SETTINGS_CURSOR, new HashMap());
            httpSettings.put(selectMethodName, (Expression)selectInvoke.getArguments().get(0));
            parentCursor.putMessage(HttpSettingsToHttpClient.OVERRIDE_CONFIG_BUILDER_HTTP_SETTINGS_CURSOR, (Object)httpSettings);
        }

        private static boolean isClientOverrideConfigurationNamedVariableType(Object parent) {
            return parent instanceof J.VariableDeclarations.NamedVariable && MoveHttpSettingsVisitor.isClientOverrideConfigurationType(((J.VariableDeclarations.NamedVariable)parent).getType());
        }
    }
}

