/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotation.SdkProtectedApi;

@SdkProtectedApi
public class CollectionUtils {
    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> List<T> mergeLists(List<T> list1, List<T> list2) {
        LinkedList<T> merged = new LinkedList<T>();
        if (list1 != null) {
            merged.addAll(list1);
        }
        if (list2 != null) {
            merged.addAll(list2);
        }
        return merged;
    }

    public static String join(Collection<String> toJoin, String separator) {
        if (CollectionUtils.isNullOrEmpty(toJoin)) {
            return "";
        }
        StringBuilder joinedString = new StringBuilder();
        int currentIndex = 0;
        for (String s : toJoin) {
            if (s != null) {
                joinedString.append(s);
            }
            if (currentIndex++ == toJoin.size() - 1) continue;
            joinedString.append(separator);
        }
        return joinedString.toString();
    }

    public static <T, U> Map<T, List<U>> deepCopyMap(Map<T, ? extends List<U>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
    }

    public static <T, U> Map<T, List<U>> deepUnmodifiableMap(Map<T, ? extends List<U>> map) {
        return Collections.unmodifiableMap(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList((List)e.getValue()))));
    }

    public static <T, U> Map<T, List<U>> deepUnmodifiableLinkedMap(Map<T, ? extends List<U>> map) {
        return Collections.unmodifiableMap(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList((List)e.getValue()), CollectionUtils::throwIllegalStateException, LinkedHashMap::new)));
    }

    public static <T, U> Map<T, List<U>> deepCopiedUnmodifiableMap(Map<T, ? extends List<U>> map) {
        return Collections.unmodifiableMap(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList(new ArrayList((Collection)e.getValue())))));
    }

    private static <T> T throwIllegalStateException(T left, T right) {
        throw new IllegalStateException("Duplicate keys are impossible when collecting from a map");
    }
}

