/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.urlconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.urlconnection.ProxyConfiguration;
import software.amazon.awssdk.http.urlconnection.UrlConnectionFactory;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class UrlConnectionHttpClient
implements SdkHttpClient {
    private static final Logger log = Logger.loggerFor(UrlConnectionHttpClient.class);
    private static final String CLIENT_NAME = "UrlConnection";
    private final AttributeMap options;
    private final UrlConnectionFactory connectionFactory;
    private final ProxyConfiguration proxyConfiguration;

    private UrlConnectionHttpClient(AttributeMap options, UrlConnectionFactory connectionFactory, DefaultBuilder builder) {
        this.options = options;
        ProxyConfiguration proxyConfiguration = this.proxyConfiguration = builder != null ? builder.proxyConfiguration : null;
        if (connectionFactory != null) {
            this.connectionFactory = connectionFactory;
        } else {
            SSLSocketFactory socketFactory = this.getSslContext(options).getSocketFactory();
            this.connectionFactory = url -> this.createDefaultConnection(url, socketFactory);
        }
    }

    private UrlConnectionHttpClient(AttributeMap options, UrlConnectionFactory connectionFactory) {
        this(options, connectionFactory, null);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static SdkHttpClient create() {
        return new DefaultBuilder().build();
    }

    public static SdkHttpClient create(UrlConnectionFactory connectionFactory) {
        return new UrlConnectionHttpClient(AttributeMap.empty(), connectionFactory);
    }

    public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
        HttpURLConnection connection = this.createAndConfigureConnection(request);
        return new RequestCallable(connection, request);
    }

    public void close() {
    }

    public String clientName() {
        return CLIENT_NAME;
    }

    private HttpURLConnection createAndConfigureConnection(HttpExecuteRequest request) {
        HttpURLConnection connection = this.connectionFactory.createConnection(request.httpRequest().getUri());
        request.httpRequest().headers().forEach((key, values) -> values.forEach(value -> connection.setRequestProperty((String)key, (String)value)));
        FunctionalUtils.invokeSafely(() -> connection.setRequestMethod(request.httpRequest().method().name()));
        if (request.contentStreamProvider().isPresent()) {
            connection.setDoOutput(true);
        }
        connection.setInstanceFollowRedirects(false);
        request.httpRequest().firstMatchingHeader("Content-Length").map(Long::parseLong).ifPresent(connection::setFixedLengthStreamingMode);
        return connection;
    }

    private HttpURLConnection createDefaultConnection(URI uri, SSLSocketFactory socketFactory) {
        HttpURLConnection connection;
        Optional<Proxy> proxy = this.determineProxy(uri);
        HttpURLConnection httpURLConnection = connection = !proxy.isPresent() ? (HttpURLConnection)FunctionalUtils.invokeSafely(() -> (HttpURLConnection)uri.toURL().openConnection()) : (HttpURLConnection)FunctionalUtils.invokeSafely(() -> (HttpURLConnection)uri.toURL().openConnection((Proxy)proxy.get()));
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            if (((Boolean)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES)).booleanValue()) {
                httpsConnection.setHostnameVerifier(NoOpHostNameVerifier.INSTANCE);
            }
            httpsConnection.setSSLSocketFactory(socketFactory);
        }
        if (proxy.isPresent() && this.shouldProxyAuthorize()) {
            connection.addRequestProperty("proxy-authorization", String.format("Basic %s", UrlConnectionHttpClient.encodedAuthToken(this.proxyConfiguration)));
        }
        connection.setConnectTimeout(NumericUtils.saturatedCast((long)((Duration)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).toMillis()));
        connection.setReadTimeout(NumericUtils.saturatedCast((long)((Duration)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).toMillis()));
        return connection;
    }

    private static String encodedAuthToken(ProxyConfiguration proxyConfiguration) {
        String authToken = String.format("%s:%s", proxyConfiguration.username(), proxyConfiguration.password());
        return Base64.getEncoder().encodeToString(authToken.getBytes(StandardCharsets.UTF_8));
    }

    private boolean shouldProxyAuthorize() {
        return this.proxyConfiguration != null && !StringUtils.isEmpty((CharSequence)this.proxyConfiguration.username()) && !StringUtils.isEmpty((CharSequence)this.proxyConfiguration.password());
    }

    private Optional<Proxy> determineProxy(URI uri) {
        if (this.isProxyEnabled() && this.isProxyHostIncluded(uri)) {
            return Optional.of(new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.proxyConfiguration.host(), this.proxyConfiguration.port())));
        }
        return Optional.empty();
    }

    private boolean isProxyHostIncluded(URI uri) {
        return this.proxyConfiguration.nonProxyHosts().stream().noneMatch(uri.getHost().toLowerCase(Locale.getDefault())::matches);
    }

    private boolean isProxyEnabled() {
        return this.proxyConfiguration != null && this.proxyConfiguration.host() != null;
    }

    private SSLContext getSslContext(AttributeMap options) {
        Validate.isTrue((options.get((AttributeMap.Key)SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER) == null || (Boolean)options.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES) == false ? 1 : 0) != 0, (String)"A TlsTrustManagerProvider can't be provided if TrustAllCertificates is also set", (Object[])new Object[0]);
        TrustManager[] trustManagers = null;
        if (options.get((AttributeMap.Key)SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER) != null) {
            trustManagers = ((TlsTrustManagersProvider)options.get((AttributeMap.Key)SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER)).trustManagers();
        }
        if (((Boolean)options.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES)).booleanValue()) {
            log.warn(() -> "SSL Certificate verification is disabled. This is not a safe setting and should only be used for testing.");
            trustManagers = new TrustManager[]{TrustAllManager.INSTANCE};
        }
        TlsKeyManagersProvider provider = (TlsKeyManagersProvider)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.TLS_KEY_MANAGERS_PROVIDER);
        KeyManager[] keyManagers = provider.keyManagers();
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private static final TrustAllManager INSTANCE = new TrustAllManager();

        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            log.debug(() -> "Accepting a client certificate: " + x509Certificates[0].getSubjectDN());
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            log.debug(() -> "Accepting a server certificate: " + x509Certificates[0].getSubjectDN());
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class NoOpHostNameVerifier
    implements HostnameVerifier {
        static final NoOpHostNameVerifier INSTANCE = new NoOpHostNameVerifier();

        private NoOpHostNameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();
        private ProxyConfiguration proxyConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder tlsKeyManagersProvider(TlsKeyManagersProvider tlsKeyManagersProvider) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.TLS_KEY_MANAGERS_PROVIDER, (Object)tlsKeyManagersProvider);
            return this;
        }

        public void setTlsKeyManagersProvider(TlsKeyManagersProvider tlsKeyManagersProvider) {
            this.tlsKeyManagersProvider(tlsKeyManagersProvider);
        }

        @Override
        public Builder tlsTrustManagersProvider(TlsTrustManagersProvider tlsTrustManagersProvider) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER, (Object)tlsTrustManagersProvider);
            return this;
        }

        public void setTlsTrustManagersProvider(TlsTrustManagersProvider tlsTrustManagersProvider) {
            this.tlsTrustManagersProvider(tlsTrustManagersProvider);
        }

        @Override
        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        @Override
        public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfigurationBuilderConsumer) {
            ProxyConfiguration.Builder builder = ProxyConfiguration.builder();
            proxyConfigurationBuilderConsumer.accept(builder);
            return this.proxyConfiguration((ProxyConfiguration)builder.build());
        }

        public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration(proxyConfiguration);
        }

        public SdkHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new UrlConnectionHttpClient(this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS), null, this);
        }
    }

    public static interface Builder
    extends SdkHttpClient.Builder<Builder> {
        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder tlsKeyManagersProvider(TlsKeyManagersProvider var1);

        public Builder tlsTrustManagersProvider(TlsTrustManagersProvider var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> var1);
    }

    private static class RequestCallable
    implements ExecutableHttpRequest {
        private final HttpURLConnection connection;
        private final HttpExecuteRequest request;
        private boolean expect100BugEncountered = false;
        private Boolean responseHasNoContent;

        private RequestCallable(HttpURLConnection connection, HttpExecuteRequest request) {
            this.connection = connection;
            this.request = request;
        }

        public HttpExecuteResponse call() throws IOException {
            Optional<OutputStream> outputStream;
            this.connection.connect();
            Optional requestContent = this.request.contentStreamProvider();
            if (requestContent.isPresent() && (outputStream = this.tryGetOutputStream()).isPresent()) {
                IoUtils.copy((InputStream)((ContentStreamProvider)requestContent.get()).newStream(), (OutputStream)outputStream.get());
            }
            int responseCode = RequestCallable.getResponseCodeSafely(this.connection);
            boolean isErrorResponse = HttpStatusFamily.of((int)responseCode).isOneOf(new HttpStatusFamily[]{HttpStatusFamily.CLIENT_ERROR, HttpStatusFamily.SERVER_ERROR});
            Optional<InputStream> responseContent = isErrorResponse ? this.tryGetErrorStream() : this.tryGetInputStream();
            AbortableInputStream responseBody = responseContent.map(AbortableInputStream::create).orElse(null);
            return HttpExecuteResponse.builder().response((SdkHttpResponse)SdkHttpResponse.builder().statusCode(responseCode).statusText(this.connection.getResponseMessage()).headers(this.extractHeaders(this.connection)).build()).responseBody(responseBody).build();
        }

        private Optional<OutputStream> tryGetOutputStream() {
            return this.getAndHandle100Bug(() -> (OutputStream)FunctionalUtils.invokeSafely(this.connection::getOutputStream), false);
        }

        private Optional<InputStream> tryGetInputStream() {
            return this.getAndHandle100Bug(() -> (InputStream)FunctionalUtils.invokeSafely(this.connection::getInputStream), true);
        }

        private Optional<InputStream> tryGetErrorStream() {
            InputStream result = (InputStream)FunctionalUtils.invokeSafely(this.connection::getErrorStream);
            if (result == null && this.expect100BugEncountered) {
                log.debug(() -> "The response payload has been dropped because of a limitation of the JDK's URL Connection HTTP client, resulting in a less descriptive SDK exception error message. Using the Apache HTTP client removes this limitation.");
            }
            return Optional.ofNullable(result);
        }

        private <T> Optional<T> getAndHandle100Bug(Supplier<T> supplier, boolean failOn100Bug) {
            try {
                return Optional.ofNullable(supplier.get());
            }
            catch (RuntimeException e) {
                if (!this.exceptionCausedBy100HandlingBug(e)) {
                    throw e;
                }
                if (this.responseHasNoContent()) {
                    return Optional.empty();
                }
                this.expect100BugEncountered = true;
                if (!failOn100Bug) {
                    return Optional.empty();
                }
                int responseCode = (Integer)FunctionalUtils.invokeSafely(this.connection::getResponseCode);
                String message = "Unable to read response payload, because service returned response code " + responseCode + " to an Expect: 100-continue request. Using another HTTP client implementation (e.g. Apache) removes this limitation.";
                throw new UncheckedIOException(new IOException(message, e));
            }
        }

        private boolean exceptionCausedBy100HandlingBug(RuntimeException e) {
            return this.requestWasExpect100Continue() != false && e.getMessage() != null && e.getMessage().startsWith("java.net.ProtocolException: Server rejected operation");
        }

        private Boolean requestWasExpect100Continue() {
            return this.request.httpRequest().firstMatchingHeader("Expect").map(expect -> expect.equalsIgnoreCase("100-continue")).orElse(false);
        }

        private boolean responseHasNoContent() {
            if (this.responseHasNoContent == null) {
                this.responseHasNoContent = this.responseNeverHasPayload((Integer)FunctionalUtils.invokeSafely(this.connection::getResponseCode)) || Objects.equals(this.connection.getHeaderField("Content-Length"), "0") || Objects.equals(this.connection.getRequestMethod(), "HEAD");
            }
            return this.responseHasNoContent;
        }

        private boolean responseNeverHasPayload(int responseCode) {
            return responseCode == 204 || responseCode == 304 || responseCode >= 100 && responseCode < 200;
        }

        private static int getResponseCodeSafely(HttpURLConnection connection) throws IOException {
            Validate.paramNotNull((Object)connection, (String)"connection");
            try {
                return connection.getResponseCode();
            }
            catch (NullPointerException e) {
                throw new IOException("Unexpected NullPointerException when trying to read response from HttpURLConnection", e);
            }
        }

        private Map<String, List<String>> extractHeaders(HttpURLConnection response) {
            return response.getHeaderFields().entrySet().stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void abort() {
            this.connection.disconnect();
        }
    }
}

