/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourceSummary;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourceSummaryListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendationResourcesResponse
extends TrustedAdvisorResponse
implements ToCopyableBuilder<Builder, ListRecommendationResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecommendationResourcesResponse.getter(ListRecommendationResourcesResponse::nextToken)).setter(ListRecommendationResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RecommendationResourceSummary>> RECOMMENDATION_RESOURCE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationResourceSummaries").getter(ListRecommendationResourcesResponse.getter(ListRecommendationResourcesResponse::recommendationResourceSummaries)).setter(ListRecommendationResourcesResponse.setter(Builder::recommendationResourceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationResourceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECOMMENDATION_RESOURCE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecommendationResourcesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RecommendationResourceSummary> recommendationResourceSummaries;

    private ListRecommendationResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recommendationResourceSummaries = builder.recommendationResourceSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecommendationResourceSummaries() {
        return this.recommendationResourceSummaries != null && !(this.recommendationResourceSummaries instanceof SdkAutoConstructList);
    }

    public final List<RecommendationResourceSummary> recommendationResourceSummaries() {
        return this.recommendationResourceSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationResourceSummaries() ? this.recommendationResourceSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationResourcesResponse)) {
            return false;
        }
        ListRecommendationResourcesResponse other = (ListRecommendationResourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecommendationResourceSummaries() == other.hasRecommendationResourceSummaries() && Objects.equals(this.recommendationResourceSummaries(), other.recommendationResourceSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendationResourcesResponse").add("NextToken", (Object)this.nextToken()).add("RecommendationResourceSummaries", this.hasRecommendationResourceSummaries() ? this.recommendationResourceSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "recommendationResourceSummaries": {
                return Optional.ofNullable(clazz.cast(this.recommendationResourceSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("recommendationResourceSummaries", RECOMMENDATION_RESOURCE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationResourcesResponse, T> g) {
        return obj -> g.apply((ListRecommendationResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TrustedAdvisorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecommendationResourceSummary> recommendationResourceSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationResourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.recommendationResourceSummaries(model.recommendationResourceSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecommendationResourceSummary.Builder> getRecommendationResourceSummaries() {
            List<RecommendationResourceSummary.Builder> result = RecommendationResourceSummaryListCopier.copyToBuilder(this.recommendationResourceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationResourceSummaries(Collection<RecommendationResourceSummary.BuilderImpl> recommendationResourceSummaries) {
            this.recommendationResourceSummaries = RecommendationResourceSummaryListCopier.copyFromBuilder(recommendationResourceSummaries);
        }

        @Override
        public final Builder recommendationResourceSummaries(Collection<RecommendationResourceSummary> recommendationResourceSummaries) {
            this.recommendationResourceSummaries = RecommendationResourceSummaryListCopier.copy(recommendationResourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationResourceSummaries(RecommendationResourceSummary ... recommendationResourceSummaries) {
            this.recommendationResourceSummaries(Arrays.asList(recommendationResourceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationResourceSummaries(Consumer<RecommendationResourceSummary.Builder> ... recommendationResourceSummaries) {
            this.recommendationResourceSummaries(Stream.of(recommendationResourceSummaries).map(c -> (RecommendationResourceSummary)((RecommendationResourceSummary.Builder)RecommendationResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRecommendationResourcesResponse build() {
            return new ListRecommendationResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TrustedAdvisorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendationResourcesResponse> {
        public Builder nextToken(String var1);

        public Builder recommendationResourceSummaries(Collection<RecommendationResourceSummary> var1);

        public Builder recommendationResourceSummaries(RecommendationResourceSummary ... var1);

        public Builder recommendationResourceSummaries(Consumer<RecommendationResourceSummary.Builder> ... var1);
    }
}

