/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationLifecycleStage;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleStageReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountRecommendationLifecycleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountRecommendationLifecycleSummary> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AccountRecommendationLifecycleSummary.getter(AccountRecommendationLifecycleSummary::accountId)).setter(AccountRecommendationLifecycleSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ACCOUNT_RECOMMENDATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountRecommendationArn").getter(AccountRecommendationLifecycleSummary.getter(AccountRecommendationLifecycleSummary::accountRecommendationArn)).setter(AccountRecommendationLifecycleSummary.setter(Builder::accountRecommendationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountRecommendationArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(AccountRecommendationLifecycleSummary.getter(AccountRecommendationLifecycleSummary::lastUpdatedAt)).setter(AccountRecommendationLifecycleSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LIFECYCLE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStage").getter(AccountRecommendationLifecycleSummary.getter(AccountRecommendationLifecycleSummary::lifecycleStageAsString)).setter(AccountRecommendationLifecycleSummary.setter(Builder::lifecycleStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStage").build()}).build();
    private static final SdkField<String> UPDATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReason").getter(AccountRecommendationLifecycleSummary.getter(AccountRecommendationLifecycleSummary::updateReason)).setter(AccountRecommendationLifecycleSummary.setter(Builder::updateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReason").build()}).build();
    private static final SdkField<String> UPDATE_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReasonCode").getter(AccountRecommendationLifecycleSummary.getter(AccountRecommendationLifecycleSummary::updateReasonCodeAsString)).setter(AccountRecommendationLifecycleSummary.setter(Builder::updateReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReasonCode").build()}).build();
    private static final SdkField<String> UPDATED_ON_BEHALF_OF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedOnBehalfOf").getter(AccountRecommendationLifecycleSummary.getter(AccountRecommendationLifecycleSummary::updatedOnBehalfOf)).setter(AccountRecommendationLifecycleSummary.setter(Builder::updatedOnBehalfOf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedOnBehalfOf").build()}).build();
    private static final SdkField<String> UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedOnBehalfOfJobTitle").getter(AccountRecommendationLifecycleSummary.getter(AccountRecommendationLifecycleSummary::updatedOnBehalfOfJobTitle)).setter(AccountRecommendationLifecycleSummary.setter(Builder::updatedOnBehalfOfJobTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedOnBehalfOfJobTitle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ACCOUNT_RECOMMENDATION_ARN_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_STAGE_FIELD, UPDATE_REASON_FIELD, UPDATE_REASON_CODE_FIELD, UPDATED_ON_BEHALF_OF_FIELD, UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountRecommendationLifecycleSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String accountRecommendationArn;
    private final Instant lastUpdatedAt;
    private final String lifecycleStage;
    private final String updateReason;
    private final String updateReasonCode;
    private final String updatedOnBehalfOf;
    private final String updatedOnBehalfOfJobTitle;

    private AccountRecommendationLifecycleSummary(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.accountRecommendationArn = builder.accountRecommendationArn;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleStage = builder.lifecycleStage;
        this.updateReason = builder.updateReason;
        this.updateReasonCode = builder.updateReasonCode;
        this.updatedOnBehalfOf = builder.updatedOnBehalfOf;
        this.updatedOnBehalfOfJobTitle = builder.updatedOnBehalfOfJobTitle;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String accountRecommendationArn() {
        return this.accountRecommendationArn;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final RecommendationLifecycleStage lifecycleStage() {
        return RecommendationLifecycleStage.fromValue(this.lifecycleStage);
    }

    public final String lifecycleStageAsString() {
        return this.lifecycleStage;
    }

    public final String updateReason() {
        return this.updateReason;
    }

    public final UpdateRecommendationLifecycleStageReasonCode updateReasonCode() {
        return UpdateRecommendationLifecycleStageReasonCode.fromValue(this.updateReasonCode);
    }

    public final String updateReasonCodeAsString() {
        return this.updateReasonCode;
    }

    public final String updatedOnBehalfOf() {
        return this.updatedOnBehalfOf;
    }

    public final String updatedOnBehalfOfJobTitle() {
        return this.updatedOnBehalfOfJobTitle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountRecommendationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedOnBehalfOf());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedOnBehalfOfJobTitle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountRecommendationLifecycleSummary)) {
            return false;
        }
        AccountRecommendationLifecycleSummary other = (AccountRecommendationLifecycleSummary)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.accountRecommendationArn(), other.accountRecommendationArn()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.lifecycleStageAsString(), other.lifecycleStageAsString()) && Objects.equals(this.updateReason(), other.updateReason()) && Objects.equals(this.updateReasonCodeAsString(), other.updateReasonCodeAsString()) && Objects.equals(this.updatedOnBehalfOf(), other.updatedOnBehalfOf()) && Objects.equals(this.updatedOnBehalfOfJobTitle(), other.updatedOnBehalfOfJobTitle());
    }

    public final String toString() {
        return ToString.builder((String)"AccountRecommendationLifecycleSummary").add("AccountId", (Object)this.accountId()).add("AccountRecommendationArn", (Object)this.accountRecommendationArn()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LifecycleStage", (Object)this.lifecycleStageAsString()).add("UpdateReason", (Object)(this.updateReason() == null ? null : "*** Sensitive Data Redacted ***")).add("UpdateReasonCode", (Object)this.updateReasonCodeAsString()).add("UpdatedOnBehalfOf", (Object)this.updatedOnBehalfOf()).add("UpdatedOnBehalfOfJobTitle", (Object)this.updatedOnBehalfOfJobTitle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "accountRecommendationArn": {
                return Optional.ofNullable(clazz.cast(this.accountRecommendationArn()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lifecycleStage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStageAsString()));
            }
            case "updateReason": {
                return Optional.ofNullable(clazz.cast(this.updateReason()));
            }
            case "updateReasonCode": {
                return Optional.ofNullable(clazz.cast(this.updateReasonCodeAsString()));
            }
            case "updatedOnBehalfOf": {
                return Optional.ofNullable(clazz.cast(this.updatedOnBehalfOf()));
            }
            case "updatedOnBehalfOfJobTitle": {
                return Optional.ofNullable(clazz.cast(this.updatedOnBehalfOfJobTitle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("accountRecommendationArn", ACCOUNT_RECOMMENDATION_ARN_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("lifecycleStage", LIFECYCLE_STAGE_FIELD);
        map.put("updateReason", UPDATE_REASON_FIELD);
        map.put("updateReasonCode", UPDATE_REASON_CODE_FIELD);
        map.put("updatedOnBehalfOf", UPDATED_ON_BEHALF_OF_FIELD);
        map.put("updatedOnBehalfOfJobTitle", UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountRecommendationLifecycleSummary, T> g) {
        return obj -> g.apply((AccountRecommendationLifecycleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String accountRecommendationArn;
        private Instant lastUpdatedAt;
        private String lifecycleStage;
        private String updateReason;
        private String updateReasonCode;
        private String updatedOnBehalfOf;
        private String updatedOnBehalfOfJobTitle;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountRecommendationLifecycleSummary model) {
            this.accountId(model.accountId);
            this.accountRecommendationArn(model.accountRecommendationArn);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lifecycleStage(model.lifecycleStage);
            this.updateReason(model.updateReason);
            this.updateReasonCode(model.updateReasonCode);
            this.updatedOnBehalfOf(model.updatedOnBehalfOf);
            this.updatedOnBehalfOfJobTitle(model.updatedOnBehalfOfJobTitle);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccountRecommendationArn() {
            return this.accountRecommendationArn;
        }

        public final void setAccountRecommendationArn(String accountRecommendationArn) {
            this.accountRecommendationArn = accountRecommendationArn;
        }

        @Override
        public final Builder accountRecommendationArn(String accountRecommendationArn) {
            this.accountRecommendationArn = accountRecommendationArn;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getLifecycleStage() {
            return this.lifecycleStage;
        }

        public final void setLifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
        }

        @Override
        public final Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        @Override
        public final Builder lifecycleStage(RecommendationLifecycleStage lifecycleStage) {
            this.lifecycleStage(lifecycleStage == null ? null : lifecycleStage.toString());
            return this;
        }

        public final String getUpdateReason() {
            return this.updateReason;
        }

        public final void setUpdateReason(String updateReason) {
            this.updateReason = updateReason;
        }

        @Override
        public final Builder updateReason(String updateReason) {
            this.updateReason = updateReason;
            return this;
        }

        public final String getUpdateReasonCode() {
            return this.updateReasonCode;
        }

        public final void setUpdateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
        }

        @Override
        public final Builder updateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
            return this;
        }

        @Override
        public final Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode updateReasonCode) {
            this.updateReasonCode(updateReasonCode == null ? null : updateReasonCode.toString());
            return this;
        }

        public final String getUpdatedOnBehalfOf() {
            return this.updatedOnBehalfOf;
        }

        public final void setUpdatedOnBehalfOf(String updatedOnBehalfOf) {
            this.updatedOnBehalfOf = updatedOnBehalfOf;
        }

        @Override
        public final Builder updatedOnBehalfOf(String updatedOnBehalfOf) {
            this.updatedOnBehalfOf = updatedOnBehalfOf;
            return this;
        }

        public final String getUpdatedOnBehalfOfJobTitle() {
            return this.updatedOnBehalfOfJobTitle;
        }

        public final void setUpdatedOnBehalfOfJobTitle(String updatedOnBehalfOfJobTitle) {
            this.updatedOnBehalfOfJobTitle = updatedOnBehalfOfJobTitle;
        }

        @Override
        public final Builder updatedOnBehalfOfJobTitle(String updatedOnBehalfOfJobTitle) {
            this.updatedOnBehalfOfJobTitle = updatedOnBehalfOfJobTitle;
            return this;
        }

        public AccountRecommendationLifecycleSummary build() {
            return new AccountRecommendationLifecycleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountRecommendationLifecycleSummary> {
        public Builder accountId(String var1);

        public Builder accountRecommendationArn(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleStage(String var1);

        public Builder lifecycleStage(RecommendationLifecycleStage var1);

        public Builder updateReason(String var1);

        public Builder updateReasonCode(String var1);

        public Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode var1);

        public Builder updatedOnBehalfOf(String var1);

        public Builder updatedOnBehalfOfJobTitle(String var1);
    }
}

