/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourceSummary;

public class ListRecommendationResourcesIterable
implements SdkIterable<ListRecommendationResourcesResponse> {
    private final TrustedAdvisorClient client;
    private final ListRecommendationResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendationResourcesIterable(TrustedAdvisorClient client, ListRecommendationResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendationResourcesResponseFetcher();
    }

    public Iterator<ListRecommendationResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommendationResourceSummary> recommendationResourceSummaries() {
        Function<ListRecommendationResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendationResourceSummaries() != null) {
                return response.recommendationResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecommendationResourcesResponseFetcher
    implements SyncPageFetcher<ListRecommendationResourcesResponse> {
        private ListRecommendationResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendationResourcesResponse nextPage(ListRecommendationResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationResourcesIterable.this.client.listRecommendationResources(ListRecommendationResourcesIterable.this.firstRequest);
            }
            return ListRecommendationResourcesIterable.this.client.listRecommendationResources((ListRecommendationResourcesRequest)((Object)ListRecommendationResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

