/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationLanguage;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillar;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationSource;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChecksRequest
extends TrustedAdvisorRequest
implements ToCopyableBuilder<Builder, ListChecksRequest> {
    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsService").getter(ListChecksRequest.getter(ListChecksRequest::awsService)).setter(ListChecksRequest.setter(Builder::awsService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsService").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(ListChecksRequest.getter(ListChecksRequest::languageAsString)).setter(ListChecksRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("language").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListChecksRequest.getter(ListChecksRequest::maxResults)).setter(ListChecksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListChecksRequest.getter(ListChecksRequest::nextToken)).setter(ListChecksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> PILLAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pillar").getter(ListChecksRequest.getter(ListChecksRequest::pillarAsString)).setter(ListChecksRequest.setter(Builder::pillar)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pillar").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ListChecksRequest.getter(ListChecksRequest::sourceAsString)).setter(ListChecksRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SERVICE_FIELD, LANGUAGE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PILLAR_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("awsService", AWS_SERVICE_FIELD);
            this.put("language", LANGUAGE_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("pillar", PILLAR_FIELD);
            this.put("source", SOURCE_FIELD);
        }
    });
    private final String awsService;
    private final String language;
    private final Integer maxResults;
    private final String nextToken;
    private final String pillar;
    private final String source;

    private ListChecksRequest(BuilderImpl builder) {
        super(builder);
        this.awsService = builder.awsService;
        this.language = builder.language;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.pillar = builder.pillar;
        this.source = builder.source;
    }

    public final String awsService() {
        return this.awsService;
    }

    public final RecommendationLanguage language() {
        return RecommendationLanguage.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final RecommendationPillar pillar() {
        return RecommendationPillar.fromValue(this.pillar);
    }

    public final String pillarAsString() {
        return this.pillar;
    }

    public final RecommendationSource source() {
        return RecommendationSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsService());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChecksRequest)) {
            return false;
        }
        ListChecksRequest other = (ListChecksRequest)((Object)obj);
        return Objects.equals(this.awsService(), other.awsService()) && Objects.equals(this.languageAsString(), other.languageAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.pillarAsString(), other.pillarAsString()) && Objects.equals(this.sourceAsString(), other.sourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListChecksRequest").add("AwsService", (Object)this.awsService()).add("Language", (Object)this.languageAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Pillar", (Object)this.pillarAsString()).add("Source", (Object)this.sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsService": {
                return Optional.ofNullable(clazz.cast(this.awsService()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "pillar": {
                return Optional.ofNullable(clazz.cast(this.pillarAsString()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListChecksRequest, T> g) {
        return obj -> g.apply((ListChecksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TrustedAdvisorRequest.BuilderImpl
    implements Builder {
        private String awsService;
        private String language;
        private Integer maxResults;
        private String nextToken;
        private String pillar;
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChecksRequest model) {
            super(model);
            this.awsService(model.awsService);
            this.language(model.language);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.pillar(model.pillar);
            this.source(model.source);
        }

        public final String getAwsService() {
            return this.awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(RecommendationLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPillar() {
            return this.pillar;
        }

        public final void setPillar(String pillar) {
            this.pillar = pillar;
        }

        @Override
        public final Builder pillar(String pillar) {
            this.pillar = pillar;
            return this;
        }

        @Override
        public final Builder pillar(RecommendationPillar pillar) {
            this.pillar(pillar == null ? null : pillar.toString());
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChecksRequest build() {
            return new ListChecksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TrustedAdvisorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChecksRequest> {
        public Builder awsService(String var1);

        public Builder language(String var1);

        public Builder language(RecommendationLanguage var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder pillar(String var1);

        public Builder pillar(RecommendationPillar var1);

        public Builder source(String var1);

        public Builder source(RecommendationSource var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

