/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.trustedadvisor.model.ExclusionStatus;
import software.amazon.awssdk.services.trustedadvisor.model.ResourceStatus;
import software.amazon.awssdk.services.trustedadvisor.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationRecommendationResourceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationRecommendationResourceSummary> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::accountId)).setter(OrganizationRecommendationResourceSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::arn)).setter(OrganizationRecommendationResourceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> AWS_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsResourceId").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::awsResourceId)).setter(OrganizationRecommendationResourceSummary.setter(Builder::awsResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsResourceId").build()}).build();
    private static final SdkField<String> EXCLUSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exclusionStatus").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::exclusionStatusAsString)).setter(OrganizationRecommendationResourceSummary.setter(Builder::exclusionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionStatus").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::id)).setter(OrganizationRecommendationResourceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::lastUpdatedAt)).setter(OrganizationRecommendationResourceSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::metadata)).setter(OrganizationRecommendationResourceSummary.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationArn").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::recommendationArn)).setter(OrganizationRecommendationResourceSummary.setter(Builder::recommendationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationArn").build()}).build();
    private static final SdkField<String> REGION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionCode").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::regionCode)).setter(OrganizationRecommendationResourceSummary.setter(Builder::regionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionCode").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(OrganizationRecommendationResourceSummary.getter(OrganizationRecommendationResourceSummary::statusAsString)).setter(OrganizationRecommendationResourceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ARN_FIELD, AWS_RESOURCE_ID_FIELD, EXCLUSION_STATUS_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, METADATA_FIELD, RECOMMENDATION_ARN_FIELD, REGION_CODE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("awsResourceId", AWS_RESOURCE_ID_FIELD);
            this.put("exclusionStatus", EXCLUSION_STATUS_FIELD);
            this.put("id", ID_FIELD);
            this.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("recommendationArn", RECOMMENDATION_ARN_FIELD);
            this.put("regionCode", REGION_CODE_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String arn;
    private final String awsResourceId;
    private final String exclusionStatus;
    private final String id;
    private final Instant lastUpdatedAt;
    private final Map<String, String> metadata;
    private final String recommendationArn;
    private final String regionCode;
    private final String status;

    private OrganizationRecommendationResourceSummary(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.awsResourceId = builder.awsResourceId;
        this.exclusionStatus = builder.exclusionStatus;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.metadata = builder.metadata;
        this.recommendationArn = builder.recommendationArn;
        this.regionCode = builder.regionCode;
        this.status = builder.status;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String awsResourceId() {
        return this.awsResourceId;
    }

    public final ExclusionStatus exclusionStatus() {
        return ExclusionStatus.fromValue(this.exclusionStatus);
    }

    public final String exclusionStatusAsString() {
        return this.exclusionStatus;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final String recommendationArn() {
        return this.recommendationArn;
    }

    public final String regionCode() {
        return this.regionCode;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationRecommendationResourceSummary)) {
            return false;
        }
        OrganizationRecommendationResourceSummary other = (OrganizationRecommendationResourceSummary)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.awsResourceId(), other.awsResourceId()) && Objects.equals(this.exclusionStatusAsString(), other.exclusionStatusAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.recommendationArn(), other.recommendationArn()) && Objects.equals(this.regionCode(), other.regionCode()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationRecommendationResourceSummary").add("AccountId", (Object)this.accountId()).add("Arn", (Object)this.arn()).add("AwsResourceId", (Object)this.awsResourceId()).add("ExclusionStatus", (Object)this.exclusionStatusAsString()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("RecommendationArn", (Object)this.recommendationArn()).add("RegionCode", (Object)this.regionCode()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "awsResourceId": {
                return Optional.ofNullable(clazz.cast(this.awsResourceId()));
            }
            case "exclusionStatus": {
                return Optional.ofNullable(clazz.cast(this.exclusionStatusAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "recommendationArn": {
                return Optional.ofNullable(clazz.cast(this.recommendationArn()));
            }
            case "regionCode": {
                return Optional.ofNullable(clazz.cast(this.regionCode()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationRecommendationResourceSummary, T> g) {
        return obj -> g.apply((OrganizationRecommendationResourceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String arn;
        private String awsResourceId;
        private String exclusionStatus;
        private String id;
        private Instant lastUpdatedAt;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String recommendationArn;
        private String regionCode;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationRecommendationResourceSummary model) {
            this.accountId(model.accountId);
            this.arn(model.arn);
            this.awsResourceId(model.awsResourceId);
            this.exclusionStatus(model.exclusionStatus);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.metadata(model.metadata);
            this.recommendationArn(model.recommendationArn);
            this.regionCode(model.regionCode);
            this.status(model.status);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAwsResourceId() {
            return this.awsResourceId;
        }

        public final void setAwsResourceId(String awsResourceId) {
            this.awsResourceId = awsResourceId;
        }

        @Override
        public final Builder awsResourceId(String awsResourceId) {
            this.awsResourceId = awsResourceId;
            return this;
        }

        public final String getExclusionStatus() {
            return this.exclusionStatus;
        }

        public final void setExclusionStatus(String exclusionStatus) {
            this.exclusionStatus = exclusionStatus;
        }

        @Override
        public final Builder exclusionStatus(String exclusionStatus) {
            this.exclusionStatus = exclusionStatus;
            return this;
        }

        @Override
        public final Builder exclusionStatus(ExclusionStatus exclusionStatus) {
            this.exclusionStatus(exclusionStatus == null ? null : exclusionStatus.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = StringMapCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = StringMapCopier.copy(metadata);
            return this;
        }

        public final String getRecommendationArn() {
            return this.recommendationArn;
        }

        public final void setRecommendationArn(String recommendationArn) {
            this.recommendationArn = recommendationArn;
        }

        @Override
        public final Builder recommendationArn(String recommendationArn) {
            this.recommendationArn = recommendationArn;
            return this;
        }

        public final String getRegionCode() {
            return this.regionCode;
        }

        public final void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        @Override
        public final Builder regionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public OrganizationRecommendationResourceSummary build() {
            return new OrganizationRecommendationResourceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationRecommendationResourceSummary> {
        public Builder accountId(String var1);

        public Builder arn(String var1);

        public Builder awsResourceId(String var1);

        public Builder exclusionStatus(String var1);

        public Builder exclusionStatus(ExclusionStatus var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder metadata(Map<String, String> var1);

        public Builder recommendationArn(String var1);

        public Builder regionCode(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);
    }
}

