/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationAwsServiceListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillar;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillarListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationSource;
import software.amazon.awssdk.services.trustedadvisor.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CheckSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CheckSummary.getter(CheckSummary::arn)).setter(CheckSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> AWS_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("awsServices").getter(CheckSummary.getter(CheckSummary::awsServices)).setter(CheckSummary.setter(Builder::awsServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CheckSummary.getter(CheckSummary::description)).setter(CheckSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CheckSummary.getter(CheckSummary::id)).setter(CheckSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(CheckSummary.getter(CheckSummary::metadata)).setter(CheckSummary.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CheckSummary.getter(CheckSummary::name)).setter(CheckSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> PILLARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pillars").getter(CheckSummary.getter(CheckSummary::pillarsAsStrings)).setter(CheckSummary.setter(Builder::pillarsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pillars").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(CheckSummary.getter(CheckSummary::sourceAsString)).setter(CheckSummary.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_SERVICES_FIELD, DESCRIPTION_FIELD, ID_FIELD, METADATA_FIELD, NAME_FIELD, PILLARS_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("awsServices", AWS_SERVICES_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("id", ID_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("name", NAME_FIELD);
            this.put("pillars", PILLARS_FIELD);
            this.put("source", SOURCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> awsServices;
    private final String description;
    private final String id;
    private final Map<String, String> metadata;
    private final String name;
    private final List<String> pillars;
    private final String source;

    private CheckSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsServices = builder.awsServices;
        this.description = builder.description;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.pillars = builder.pillars;
        this.source = builder.source;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAwsServices() {
        return this.awsServices != null && !(this.awsServices instanceof SdkAutoConstructList);
    }

    public final List<String> awsServices() {
        return this.awsServices;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final String name() {
        return this.name;
    }

    public final List<RecommendationPillar> pillars() {
        return RecommendationPillarListCopier.copyStringToEnum(this.pillars);
    }

    public final boolean hasPillars() {
        return this.pillars != null && !(this.pillars instanceof SdkAutoConstructList);
    }

    public final List<String> pillarsAsStrings() {
        return this.pillars;
    }

    public final RecommendationSource source() {
        return RecommendationSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsServices() ? this.awsServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillars() ? this.pillarsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckSummary)) {
            return false;
        }
        CheckSummary other = (CheckSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasAwsServices() == other.hasAwsServices() && Objects.equals(this.awsServices(), other.awsServices()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.name(), other.name()) && this.hasPillars() == other.hasPillars() && Objects.equals(this.pillarsAsStrings(), other.pillarsAsStrings()) && Objects.equals(this.sourceAsString(), other.sourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CheckSummary").add("Arn", (Object)this.arn()).add("AwsServices", this.hasAwsServices() ? this.awsServices() : null).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("Name", (Object)this.name()).add("Pillars", this.hasPillars() ? this.pillarsAsStrings() : null).add("Source", (Object)this.sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "awsServices": {
                return Optional.ofNullable(clazz.cast(this.awsServices()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "pillars": {
                return Optional.ofNullable(clazz.cast(this.pillarsAsStrings()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CheckSummary, T> g) {
        return obj -> g.apply((CheckSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> awsServices = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String id;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private List<String> pillars = DefaultSdkAutoConstructList.getInstance();
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckSummary model) {
            this.arn(model.arn);
            this.awsServices(model.awsServices);
            this.description(model.description);
            this.id(model.id);
            this.metadata(model.metadata);
            this.name(model.name);
            this.pillarsWithStrings(model.pillars);
            this.source(model.source);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAwsServices() {
            if (this.awsServices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsServices;
        }

        public final void setAwsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
        }

        @Override
        public final Builder awsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(String ... awsServices) {
            this.awsServices(Arrays.asList(awsServices));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = StringMapCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = StringMapCopier.copy(metadata);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getPillars() {
            if (this.pillars instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pillars;
        }

        public final void setPillars(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
        }

        @Override
        public final Builder pillarsWithStrings(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarsWithStrings(String ... pillars) {
            this.pillarsWithStrings(Arrays.asList(pillars));
            return this;
        }

        @Override
        public final Builder pillars(Collection<RecommendationPillar> pillars) {
            this.pillars = RecommendationPillarListCopier.copyEnumToString(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(RecommendationPillar ... pillars) {
            this.pillars(Arrays.asList(pillars));
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public CheckSummary build() {
            return new CheckSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CheckSummary> {
        public Builder arn(String var1);

        public Builder awsServices(Collection<String> var1);

        public Builder awsServices(String ... var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder name(String var1);

        public Builder pillarsWithStrings(Collection<String> var1);

        public Builder pillarsWithStrings(String ... var1);

        public Builder pillars(Collection<RecommendationPillar> var1);

        public Builder pillars(RecommendationPillar ... var1);

        public Builder source(String var1);

        public Builder source(RecommendationSource var1);
    }
}

