/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationAwsServiceListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationLifecycleStage;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillar;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillarListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillarSpecificAggregates;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourcesAggregates;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationSource;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationStatus;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RecommendationSummary.getter(RecommendationSummary::arn)).setter(RecommendationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> AWS_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("awsServices").getter(RecommendationSummary.getter(RecommendationSummary::awsServices)).setter(RecommendationSummary.setter(Builder::awsServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHECK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkArn").getter(RecommendationSummary.getter(RecommendationSummary::checkArn)).setter(RecommendationSummary.setter(Builder::checkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(RecommendationSummary.getter(RecommendationSummary::createdAt)).setter(RecommendationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(RecommendationSummary.getter(RecommendationSummary::id)).setter(RecommendationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(RecommendationSummary.getter(RecommendationSummary::lastUpdatedAt)).setter(RecommendationSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LIFECYCLE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStage").getter(RecommendationSummary.getter(RecommendationSummary::lifecycleStageAsString)).setter(RecommendationSummary.setter(Builder::lifecycleStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStage").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RecommendationSummary.getter(RecommendationSummary::name)).setter(RecommendationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RecommendationPillarSpecificAggregates> PILLAR_SPECIFIC_AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pillarSpecificAggregates").getter(RecommendationSummary.getter(RecommendationSummary::pillarSpecificAggregates)).setter(RecommendationSummary.setter(Builder::pillarSpecificAggregates)).constructor(RecommendationPillarSpecificAggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pillarSpecificAggregates").build()}).build();
    private static final SdkField<List<String>> PILLARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pillars").getter(RecommendationSummary.getter(RecommendationSummary::pillarsAsStrings)).setter(RecommendationSummary.setter(Builder::pillarsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pillars").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecommendationResourcesAggregates> RESOURCES_AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcesAggregates").getter(RecommendationSummary.getter(RecommendationSummary::resourcesAggregates)).setter(RecommendationSummary.setter(Builder::resourcesAggregates)).constructor(RecommendationResourcesAggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesAggregates").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(RecommendationSummary.getter(RecommendationSummary::sourceAsString)).setter(RecommendationSummary.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RecommendationSummary.getter(RecommendationSummary::statusAsString)).setter(RecommendationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RecommendationSummary.getter(RecommendationSummary::typeAsString)).setter(RecommendationSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_SERVICES_FIELD, CHECK_ARN_FIELD, CREATED_AT_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_STAGE_FIELD, NAME_FIELD, PILLAR_SPECIFIC_AGGREGATES_FIELD, PILLARS_FIELD, RESOURCES_AGGREGATES_FIELD, SOURCE_FIELD, STATUS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> awsServices;
    private final String checkArn;
    private final Instant createdAt;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String lifecycleStage;
    private final String name;
    private final RecommendationPillarSpecificAggregates pillarSpecificAggregates;
    private final List<String> pillars;
    private final RecommendationResourcesAggregates resourcesAggregates;
    private final String source;
    private final String status;
    private final String type;

    private RecommendationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsServices = builder.awsServices;
        this.checkArn = builder.checkArn;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleStage = builder.lifecycleStage;
        this.name = builder.name;
        this.pillarSpecificAggregates = builder.pillarSpecificAggregates;
        this.pillars = builder.pillars;
        this.resourcesAggregates = builder.resourcesAggregates;
        this.source = builder.source;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAwsServices() {
        return this.awsServices != null && !(this.awsServices instanceof SdkAutoConstructList);
    }

    public final List<String> awsServices() {
        return this.awsServices;
    }

    public final String checkArn() {
        return this.checkArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final RecommendationLifecycleStage lifecycleStage() {
        return RecommendationLifecycleStage.fromValue(this.lifecycleStage);
    }

    public final String lifecycleStageAsString() {
        return this.lifecycleStage;
    }

    public final String name() {
        return this.name;
    }

    public final RecommendationPillarSpecificAggregates pillarSpecificAggregates() {
        return this.pillarSpecificAggregates;
    }

    public final List<RecommendationPillar> pillars() {
        return RecommendationPillarListCopier.copyStringToEnum(this.pillars);
    }

    public final boolean hasPillars() {
        return this.pillars != null && !(this.pillars instanceof SdkAutoConstructList);
    }

    public final List<String> pillarsAsStrings() {
        return this.pillars;
    }

    public final RecommendationResourcesAggregates resourcesAggregates() {
        return this.resourcesAggregates;
    }

    public final RecommendationSource source() {
        return RecommendationSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final RecommendationStatus status() {
        return RecommendationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final RecommendationType type() {
        return RecommendationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsServices() ? this.awsServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.checkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarSpecificAggregates());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillars() ? this.pillarsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesAggregates());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasAwsServices() == other.hasAwsServices() && Objects.equals(this.awsServices(), other.awsServices()) && Objects.equals(this.checkArn(), other.checkArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.lifecycleStageAsString(), other.lifecycleStageAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pillarSpecificAggregates(), other.pillarSpecificAggregates()) && this.hasPillars() == other.hasPillars() && Objects.equals(this.pillarsAsStrings(), other.pillarsAsStrings()) && Objects.equals(this.resourcesAggregates(), other.resourcesAggregates()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationSummary").add("Arn", (Object)this.arn()).add("AwsServices", this.hasAwsServices() ? this.awsServices() : null).add("CheckArn", (Object)this.checkArn()).add("CreatedAt", (Object)this.createdAt()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LifecycleStage", (Object)this.lifecycleStageAsString()).add("Name", (Object)this.name()).add("PillarSpecificAggregates", (Object)this.pillarSpecificAggregates()).add("Pillars", this.hasPillars() ? this.pillarsAsStrings() : null).add("ResourcesAggregates", (Object)this.resourcesAggregates()).add("Source", (Object)this.sourceAsString()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "awsServices": {
                return Optional.ofNullable(clazz.cast(this.awsServices()));
            }
            case "checkArn": {
                return Optional.ofNullable(clazz.cast(this.checkArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lifecycleStage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStageAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "pillarSpecificAggregates": {
                return Optional.ofNullable(clazz.cast(this.pillarSpecificAggregates()));
            }
            case "pillars": {
                return Optional.ofNullable(clazz.cast(this.pillarsAsStrings()));
            }
            case "resourcesAggregates": {
                return Optional.ofNullable(clazz.cast(this.resourcesAggregates()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> awsServices = DefaultSdkAutoConstructList.getInstance();
        private String checkArn;
        private Instant createdAt;
        private String id;
        private Instant lastUpdatedAt;
        private String lifecycleStage;
        private String name;
        private RecommendationPillarSpecificAggregates pillarSpecificAggregates;
        private List<String> pillars = DefaultSdkAutoConstructList.getInstance();
        private RecommendationResourcesAggregates resourcesAggregates;
        private String source;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            this.arn(model.arn);
            this.awsServices(model.awsServices);
            this.checkArn(model.checkArn);
            this.createdAt(model.createdAt);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lifecycleStage(model.lifecycleStage);
            this.name(model.name);
            this.pillarSpecificAggregates(model.pillarSpecificAggregates);
            this.pillarsWithStrings(model.pillars);
            this.resourcesAggregates(model.resourcesAggregates);
            this.source(model.source);
            this.status(model.status);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAwsServices() {
            if (this.awsServices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsServices;
        }

        public final void setAwsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
        }

        @Override
        public final Builder awsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(String ... awsServices) {
            this.awsServices(Arrays.asList(awsServices));
            return this;
        }

        public final String getCheckArn() {
            return this.checkArn;
        }

        public final void setCheckArn(String checkArn) {
            this.checkArn = checkArn;
        }

        @Override
        public final Builder checkArn(String checkArn) {
            this.checkArn = checkArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getLifecycleStage() {
            return this.lifecycleStage;
        }

        public final void setLifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
        }

        @Override
        public final Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        @Override
        public final Builder lifecycleStage(RecommendationLifecycleStage lifecycleStage) {
            this.lifecycleStage(lifecycleStage == null ? null : lifecycleStage.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RecommendationPillarSpecificAggregates.Builder getPillarSpecificAggregates() {
            return this.pillarSpecificAggregates != null ? this.pillarSpecificAggregates.toBuilder() : null;
        }

        public final void setPillarSpecificAggregates(RecommendationPillarSpecificAggregates.BuilderImpl pillarSpecificAggregates) {
            this.pillarSpecificAggregates = pillarSpecificAggregates != null ? pillarSpecificAggregates.build() : null;
        }

        @Override
        public final Builder pillarSpecificAggregates(RecommendationPillarSpecificAggregates pillarSpecificAggregates) {
            this.pillarSpecificAggregates = pillarSpecificAggregates;
            return this;
        }

        public final Collection<String> getPillars() {
            if (this.pillars instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pillars;
        }

        public final void setPillars(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
        }

        @Override
        public final Builder pillarsWithStrings(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarsWithStrings(String ... pillars) {
            this.pillarsWithStrings(Arrays.asList(pillars));
            return this;
        }

        @Override
        public final Builder pillars(Collection<RecommendationPillar> pillars) {
            this.pillars = RecommendationPillarListCopier.copyEnumToString(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(RecommendationPillar ... pillars) {
            this.pillars(Arrays.asList(pillars));
            return this;
        }

        public final RecommendationResourcesAggregates.Builder getResourcesAggregates() {
            return this.resourcesAggregates != null ? this.resourcesAggregates.toBuilder() : null;
        }

        public final void setResourcesAggregates(RecommendationResourcesAggregates.BuilderImpl resourcesAggregates) {
            this.resourcesAggregates = resourcesAggregates != null ? resourcesAggregates.build() : null;
        }

        @Override
        public final Builder resourcesAggregates(RecommendationResourcesAggregates resourcesAggregates) {
            this.resourcesAggregates = resourcesAggregates;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecommendationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSummary> {
        public Builder arn(String var1);

        public Builder awsServices(Collection<String> var1);

        public Builder awsServices(String ... var1);

        public Builder checkArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleStage(String var1);

        public Builder lifecycleStage(RecommendationLifecycleStage var1);

        public Builder name(String var1);

        public Builder pillarSpecificAggregates(RecommendationPillarSpecificAggregates var1);

        default public Builder pillarSpecificAggregates(Consumer<RecommendationPillarSpecificAggregates.Builder> pillarSpecificAggregates) {
            return this.pillarSpecificAggregates((RecommendationPillarSpecificAggregates)((RecommendationPillarSpecificAggregates.Builder)RecommendationPillarSpecificAggregates.builder().applyMutation(pillarSpecificAggregates)).build());
        }

        public Builder pillarsWithStrings(Collection<String> var1);

        public Builder pillarsWithStrings(String ... var1);

        public Builder pillars(Collection<RecommendationPillar> var1);

        public Builder pillars(RecommendationPillar ... var1);

        public Builder resourcesAggregates(RecommendationResourcesAggregates var1);

        default public Builder resourcesAggregates(Consumer<RecommendationResourcesAggregates.Builder> resourcesAggregates) {
            return this.resourcesAggregates((RecommendationResourcesAggregates)((RecommendationResourcesAggregates.Builder)RecommendationResourcesAggregates.builder().applyMutation(resourcesAggregates)).build());
        }

        public Builder source(String var1);

        public Builder source(RecommendationSource var1);

        public Builder status(String var1);

        public Builder status(RecommendationStatus var1);

        public Builder type(String var1);

        public Builder type(RecommendationType var1);
    }
}

