/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorRequest;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleStage;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleStageReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecommendationLifecycleRequest
extends TrustedAdvisorRequest
implements ToCopyableBuilder<Builder, UpdateRecommendationLifecycleRequest> {
    private static final SdkField<String> LIFECYCLE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStage").getter(UpdateRecommendationLifecycleRequest.getter(UpdateRecommendationLifecycleRequest::lifecycleStageAsString)).setter(UpdateRecommendationLifecycleRequest.setter(Builder::lifecycleStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStage").build()}).build();
    private static final SdkField<String> RECOMMENDATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationIdentifier").getter(UpdateRecommendationLifecycleRequest.getter(UpdateRecommendationLifecycleRequest::recommendationIdentifier)).setter(UpdateRecommendationLifecycleRequest.setter(Builder::recommendationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("recommendationIdentifier").build()}).build();
    private static final SdkField<String> UPDATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReason").getter(UpdateRecommendationLifecycleRequest.getter(UpdateRecommendationLifecycleRequest::updateReason)).setter(UpdateRecommendationLifecycleRequest.setter(Builder::updateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReason").build()}).build();
    private static final SdkField<String> UPDATE_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReasonCode").getter(UpdateRecommendationLifecycleRequest.getter(UpdateRecommendationLifecycleRequest::updateReasonCodeAsString)).setter(UpdateRecommendationLifecycleRequest.setter(Builder::updateReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReasonCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_STAGE_FIELD, RECOMMENDATION_IDENTIFIER_FIELD, UPDATE_REASON_FIELD, UPDATE_REASON_CODE_FIELD));
    private final String lifecycleStage;
    private final String recommendationIdentifier;
    private final String updateReason;
    private final String updateReasonCode;

    private UpdateRecommendationLifecycleRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleStage = builder.lifecycleStage;
        this.recommendationIdentifier = builder.recommendationIdentifier;
        this.updateReason = builder.updateReason;
        this.updateReasonCode = builder.updateReasonCode;
    }

    public final UpdateRecommendationLifecycleStage lifecycleStage() {
        return UpdateRecommendationLifecycleStage.fromValue(this.lifecycleStage);
    }

    public final String lifecycleStageAsString() {
        return this.lifecycleStage;
    }

    public final String recommendationIdentifier() {
        return this.recommendationIdentifier;
    }

    public final String updateReason() {
        return this.updateReason;
    }

    public final UpdateRecommendationLifecycleStageReasonCode updateReasonCode() {
        return UpdateRecommendationLifecycleStageReasonCode.fromValue(this.updateReasonCode);
    }

    public final String updateReasonCodeAsString() {
        return this.updateReasonCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReasonCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecommendationLifecycleRequest)) {
            return false;
        }
        UpdateRecommendationLifecycleRequest other = (UpdateRecommendationLifecycleRequest)((Object)obj);
        return Objects.equals(this.lifecycleStageAsString(), other.lifecycleStageAsString()) && Objects.equals(this.recommendationIdentifier(), other.recommendationIdentifier()) && Objects.equals(this.updateReason(), other.updateReason()) && Objects.equals(this.updateReasonCodeAsString(), other.updateReasonCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecommendationLifecycleRequest").add("LifecycleStage", (Object)this.lifecycleStageAsString()).add("RecommendationIdentifier", (Object)this.recommendationIdentifier()).add("UpdateReason", (Object)(this.updateReason() == null ? null : "*** Sensitive Data Redacted ***")).add("UpdateReasonCode", (Object)this.updateReasonCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lifecycleStage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStageAsString()));
            }
            case "recommendationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.recommendationIdentifier()));
            }
            case "updateReason": {
                return Optional.ofNullable(clazz.cast(this.updateReason()));
            }
            case "updateReasonCode": {
                return Optional.ofNullable(clazz.cast(this.updateReasonCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecommendationLifecycleRequest, T> g) {
        return obj -> g.apply((UpdateRecommendationLifecycleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TrustedAdvisorRequest.BuilderImpl
    implements Builder {
        private String lifecycleStage;
        private String recommendationIdentifier;
        private String updateReason;
        private String updateReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecommendationLifecycleRequest model) {
            super(model);
            this.lifecycleStage(model.lifecycleStage);
            this.recommendationIdentifier(model.recommendationIdentifier);
            this.updateReason(model.updateReason);
            this.updateReasonCode(model.updateReasonCode);
        }

        public final String getLifecycleStage() {
            return this.lifecycleStage;
        }

        public final void setLifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
        }

        @Override
        public final Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        @Override
        public final Builder lifecycleStage(UpdateRecommendationLifecycleStage lifecycleStage) {
            this.lifecycleStage(lifecycleStage == null ? null : lifecycleStage.toString());
            return this;
        }

        public final String getRecommendationIdentifier() {
            return this.recommendationIdentifier;
        }

        public final void setRecommendationIdentifier(String recommendationIdentifier) {
            this.recommendationIdentifier = recommendationIdentifier;
        }

        @Override
        public final Builder recommendationIdentifier(String recommendationIdentifier) {
            this.recommendationIdentifier = recommendationIdentifier;
            return this;
        }

        public final String getUpdateReason() {
            return this.updateReason;
        }

        public final void setUpdateReason(String updateReason) {
            this.updateReason = updateReason;
        }

        @Override
        public final Builder updateReason(String updateReason) {
            this.updateReason = updateReason;
            return this;
        }

        public final String getUpdateReasonCode() {
            return this.updateReasonCode;
        }

        public final void setUpdateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
        }

        @Override
        public final Builder updateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
            return this;
        }

        @Override
        public final Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode updateReasonCode) {
            this.updateReasonCode(updateReasonCode == null ? null : updateReasonCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecommendationLifecycleRequest build() {
            return new UpdateRecommendationLifecycleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TrustedAdvisorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecommendationLifecycleRequest> {
        public Builder lifecycleStage(String var1);

        public Builder lifecycleStage(UpdateRecommendationLifecycleStage var1);

        public Builder recommendationIdentifier(String var1);

        public Builder updateReason(String var1);

        public Builder updateReasonCode(String var1);

        public Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

