/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorAsyncClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.AccountRecommendationLifecycleSummary;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse;

public class ListOrganizationRecommendationAccountsPublisher
implements SdkPublisher<ListOrganizationRecommendationAccountsResponse> {
    private final TrustedAdvisorAsyncClient client;
    private final ListOrganizationRecommendationAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationRecommendationAccountsPublisher(TrustedAdvisorAsyncClient client, ListOrganizationRecommendationAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationRecommendationAccountsPublisher(TrustedAdvisorAsyncClient client, ListOrganizationRecommendationAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationRecommendationAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationRecommendationAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountRecommendationLifecycleSummary> accountRecommendationLifecycleSummaries() {
        Function<ListOrganizationRecommendationAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountRecommendationLifecycleSummaries() != null) {
                return response.accountRecommendationLifecycleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOrganizationRecommendationAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOrganizationRecommendationAccountsResponseFetcher
    implements AsyncPageFetcher<ListOrganizationRecommendationAccountsResponse> {
        private ListOrganizationRecommendationAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationRecommendationAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrganizationRecommendationAccountsResponse> nextPage(ListOrganizationRecommendationAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationRecommendationAccountsPublisher.this.client.listOrganizationRecommendationAccounts(ListOrganizationRecommendationAccountsPublisher.this.firstRequest);
            }
            return ListOrganizationRecommendationAccountsPublisher.this.client.listOrganizationRecommendationAccounts((ListOrganizationRecommendationAccountsRequest)((Object)ListOrganizationRecommendationAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

