/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorAsyncClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.OrganizationRecommendationSummary;

public class ListOrganizationRecommendationsPublisher
implements SdkPublisher<ListOrganizationRecommendationsResponse> {
    private final TrustedAdvisorAsyncClient client;
    private final ListOrganizationRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationRecommendationsPublisher(TrustedAdvisorAsyncClient client, ListOrganizationRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationRecommendationsPublisher(TrustedAdvisorAsyncClient client, ListOrganizationRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrganizationRecommendationSummary> organizationRecommendationSummaries() {
        Function<ListOrganizationRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationRecommendationSummaries() != null) {
                return response.organizationRecommendationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOrganizationRecommendationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOrganizationRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListOrganizationRecommendationsResponse> {
        private ListOrganizationRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrganizationRecommendationsResponse> nextPage(ListOrganizationRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationRecommendationsPublisher.this.client.listOrganizationRecommendations(ListOrganizationRecommendationsPublisher.this.firstRequest);
            }
            return ListOrganizationRecommendationsPublisher.this.client.listOrganizationRecommendations((ListOrganizationRecommendationsRequest)((Object)ListOrganizationRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

