/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.TerminologyDataFormat;
import software.amazon.awssdk.services.translate.model.TranslateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTerminologyRequest
extends TranslateRequest
implements ToCopyableBuilder<Builder, GetTerminologyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetTerminologyRequest.getter(GetTerminologyRequest::name)).setter(GetTerminologyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TERMINOLOGY_DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetTerminologyRequest.getter(GetTerminologyRequest::terminologyDataFormatAsString)).setter(GetTerminologyRequest.setter(Builder::terminologyDataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyDataFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TERMINOLOGY_DATA_FORMAT_FIELD));
    private final String name;
    private final String terminologyDataFormat;

    private GetTerminologyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.terminologyDataFormat = builder.terminologyDataFormat;
    }

    public String name() {
        return this.name;
    }

    public TerminologyDataFormat terminologyDataFormat() {
        return TerminologyDataFormat.fromValue(this.terminologyDataFormat);
    }

    public String terminologyDataFormatAsString() {
        return this.terminologyDataFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminologyDataFormatAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTerminologyRequest)) {
            return false;
        }
        GetTerminologyRequest other = (GetTerminologyRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.terminologyDataFormatAsString(), other.terminologyDataFormatAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetTerminologyRequest").add("Name", (Object)this.name()).add("TerminologyDataFormat", (Object)this.terminologyDataFormatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TerminologyDataFormat": {
                return Optional.ofNullable(clazz.cast(this.terminologyDataFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTerminologyRequest, T> g) {
        return obj -> g.apply((GetTerminologyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateRequest.BuilderImpl
    implements Builder {
        private String name;
        private String terminologyDataFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTerminologyRequest model) {
            super(model);
            this.name(model.name);
            this.terminologyDataFormat(model.terminologyDataFormat);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTerminologyDataFormatAsString() {
            return this.terminologyDataFormat;
        }

        @Override
        public final Builder terminologyDataFormat(String terminologyDataFormat) {
            this.terminologyDataFormat = terminologyDataFormat;
            return this;
        }

        @Override
        public final Builder terminologyDataFormat(TerminologyDataFormat terminologyDataFormat) {
            this.terminologyDataFormat(terminologyDataFormat.toString());
            return this;
        }

        public final void setTerminologyDataFormat(String terminologyDataFormat) {
            this.terminologyDataFormat = terminologyDataFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTerminologyRequest build() {
            return new GetTerminologyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTerminologyRequest> {
        public Builder name(String var1);

        public Builder terminologyDataFormat(String var1);

        public Builder terminologyDataFormat(TerminologyDataFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

