/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.AgreementStatusType;
import software.amazon.awssdk.services.transfer.model.CustomDirectoriesType;
import software.amazon.awssdk.services.transfer.model.EnforceMessageSigningType;
import software.amazon.awssdk.services.transfer.model.PreserveFilenameType;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedAgreement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedAgreement> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribedAgreement.getter(DescribedAgreement::arn)).setter(DescribedAgreement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgreementId").getter(DescribedAgreement.getter(DescribedAgreement::agreementId)).setter(DescribedAgreement.setter(Builder::agreementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgreementId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribedAgreement.getter(DescribedAgreement::description)).setter(DescribedAgreement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribedAgreement.getter(DescribedAgreement::statusAsString)).setter(DescribedAgreement.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(DescribedAgreement.getter(DescribedAgreement::serverId)).setter(DescribedAgreement.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> LOCAL_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalProfileId").getter(DescribedAgreement.getter(DescribedAgreement::localProfileId)).setter(DescribedAgreement.setter(Builder::localProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalProfileId").build()}).build();
    private static final SdkField<String> PARTNER_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerProfileId").getter(DescribedAgreement.getter(DescribedAgreement::partnerProfileId)).setter(DescribedAgreement.setter(Builder::partnerProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerProfileId").build()}).build();
    private static final SdkField<String> BASE_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseDirectory").getter(DescribedAgreement.getter(DescribedAgreement::baseDirectory)).setter(DescribedAgreement.setter(Builder::baseDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseDirectory").build()}).build();
    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessRole").getter(DescribedAgreement.getter(DescribedAgreement::accessRole)).setter(DescribedAgreement.setter(Builder::accessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribedAgreement.getter(DescribedAgreement::tags)).setter(DescribedAgreement.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRESERVE_FILENAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreserveFilename").getter(DescribedAgreement.getter(DescribedAgreement::preserveFilenameAsString)).setter(DescribedAgreement.setter(Builder::preserveFilename)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveFilename").build()}).build();
    private static final SdkField<String> ENFORCE_MESSAGE_SIGNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnforceMessageSigning").getter(DescribedAgreement.getter(DescribedAgreement::enforceMessageSigningAsString)).setter(DescribedAgreement.setter(Builder::enforceMessageSigning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceMessageSigning").build()}).build();
    private static final SdkField<CustomDirectoriesType> CUSTOM_DIRECTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomDirectories").getter(DescribedAgreement.getter(DescribedAgreement::customDirectories)).setter(DescribedAgreement.setter(Builder::customDirectories)).constructor(CustomDirectoriesType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDirectories").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AGREEMENT_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, SERVER_ID_FIELD, LOCAL_PROFILE_ID_FIELD, PARTNER_PROFILE_ID_FIELD, BASE_DIRECTORY_FIELD, ACCESS_ROLE_FIELD, TAGS_FIELD, PRESERVE_FILENAME_FIELD, ENFORCE_MESSAGE_SIGNING_FIELD, CUSTOM_DIRECTORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribedAgreement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String agreementId;
    private final String description;
    private final String status;
    private final String serverId;
    private final String localProfileId;
    private final String partnerProfileId;
    private final String baseDirectory;
    private final String accessRole;
    private final List<Tag> tags;
    private final String preserveFilename;
    private final String enforceMessageSigning;
    private final CustomDirectoriesType customDirectories;

    private DescribedAgreement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.agreementId = builder.agreementId;
        this.description = builder.description;
        this.status = builder.status;
        this.serverId = builder.serverId;
        this.localProfileId = builder.localProfileId;
        this.partnerProfileId = builder.partnerProfileId;
        this.baseDirectory = builder.baseDirectory;
        this.accessRole = builder.accessRole;
        this.tags = builder.tags;
        this.preserveFilename = builder.preserveFilename;
        this.enforceMessageSigning = builder.enforceMessageSigning;
        this.customDirectories = builder.customDirectories;
    }

    public final String arn() {
        return this.arn;
    }

    public final String agreementId() {
        return this.agreementId;
    }

    public final String description() {
        return this.description;
    }

    public final AgreementStatusType status() {
        return AgreementStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String localProfileId() {
        return this.localProfileId;
    }

    public final String partnerProfileId() {
        return this.partnerProfileId;
    }

    public final String baseDirectory() {
        return this.baseDirectory;
    }

    public final String accessRole() {
        return this.accessRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final PreserveFilenameType preserveFilename() {
        return PreserveFilenameType.fromValue(this.preserveFilename);
    }

    public final String preserveFilenameAsString() {
        return this.preserveFilename;
    }

    public final EnforceMessageSigningType enforceMessageSigning() {
        return EnforceMessageSigningType.fromValue(this.enforceMessageSigning);
    }

    public final String enforceMessageSigningAsString() {
        return this.enforceMessageSigning;
    }

    public final CustomDirectoriesType customDirectories() {
        return this.customDirectories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveFilenameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceMessageSigningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDirectories());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedAgreement)) {
            return false;
        }
        DescribedAgreement other = (DescribedAgreement)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.agreementId(), other.agreementId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.localProfileId(), other.localProfileId()) && Objects.equals(this.partnerProfileId(), other.partnerProfileId()) && Objects.equals(this.baseDirectory(), other.baseDirectory()) && Objects.equals(this.accessRole(), other.accessRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.preserveFilenameAsString(), other.preserveFilenameAsString()) && Objects.equals(this.enforceMessageSigningAsString(), other.enforceMessageSigningAsString()) && Objects.equals(this.customDirectories(), other.customDirectories());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedAgreement").add("Arn", (Object)this.arn()).add("AgreementId", (Object)this.agreementId()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("ServerId", (Object)this.serverId()).add("LocalProfileId", (Object)this.localProfileId()).add("PartnerProfileId", (Object)this.partnerProfileId()).add("BaseDirectory", (Object)this.baseDirectory()).add("AccessRole", (Object)this.accessRole()).add("Tags", this.hasTags() ? this.tags() : null).add("PreserveFilename", (Object)this.preserveFilenameAsString()).add("EnforceMessageSigning", (Object)this.enforceMessageSigningAsString()).add("CustomDirectories", (Object)this.customDirectories()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AgreementId": {
                return Optional.ofNullable(clazz.cast(this.agreementId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "LocalProfileId": {
                return Optional.ofNullable(clazz.cast(this.localProfileId()));
            }
            case "PartnerProfileId": {
                return Optional.ofNullable(clazz.cast(this.partnerProfileId()));
            }
            case "BaseDirectory": {
                return Optional.ofNullable(clazz.cast(this.baseDirectory()));
            }
            case "AccessRole": {
                return Optional.ofNullable(clazz.cast(this.accessRole()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PreserveFilename": {
                return Optional.ofNullable(clazz.cast(this.preserveFilenameAsString()));
            }
            case "EnforceMessageSigning": {
                return Optional.ofNullable(clazz.cast(this.enforceMessageSigningAsString()));
            }
            case "CustomDirectories": {
                return Optional.ofNullable(clazz.cast(this.customDirectories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("AgreementId", AGREEMENT_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ServerId", SERVER_ID_FIELD);
        map.put("LocalProfileId", LOCAL_PROFILE_ID_FIELD);
        map.put("PartnerProfileId", PARTNER_PROFILE_ID_FIELD);
        map.put("BaseDirectory", BASE_DIRECTORY_FIELD);
        map.put("AccessRole", ACCESS_ROLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("PreserveFilename", PRESERVE_FILENAME_FIELD);
        map.put("EnforceMessageSigning", ENFORCE_MESSAGE_SIGNING_FIELD);
        map.put("CustomDirectories", CUSTOM_DIRECTORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedAgreement, T> g) {
        return obj -> g.apply((DescribedAgreement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String agreementId;
        private String description;
        private String status;
        private String serverId;
        private String localProfileId;
        private String partnerProfileId;
        private String baseDirectory;
        private String accessRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String preserveFilename;
        private String enforceMessageSigning;
        private CustomDirectoriesType customDirectories;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedAgreement model) {
            this.arn(model.arn);
            this.agreementId(model.agreementId);
            this.description(model.description);
            this.status(model.status);
            this.serverId(model.serverId);
            this.localProfileId(model.localProfileId);
            this.partnerProfileId(model.partnerProfileId);
            this.baseDirectory(model.baseDirectory);
            this.accessRole(model.accessRole);
            this.tags(model.tags);
            this.preserveFilename(model.preserveFilename);
            this.enforceMessageSigning(model.enforceMessageSigning);
            this.customDirectories(model.customDirectories);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAgreementId() {
            return this.agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgreementStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getLocalProfileId() {
            return this.localProfileId;
        }

        public final void setLocalProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
        }

        @Override
        public final Builder localProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        public final String getPartnerProfileId() {
            return this.partnerProfileId;
        }

        public final void setPartnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
        }

        @Override
        public final Builder partnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        public final String getBaseDirectory() {
            return this.baseDirectory;
        }

        public final void setBaseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
        }

        @Override
        public final Builder baseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public final String getAccessRole() {
            return this.accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPreserveFilename() {
            return this.preserveFilename;
        }

        public final void setPreserveFilename(String preserveFilename) {
            this.preserveFilename = preserveFilename;
        }

        @Override
        public final Builder preserveFilename(String preserveFilename) {
            this.preserveFilename = preserveFilename;
            return this;
        }

        @Override
        public final Builder preserveFilename(PreserveFilenameType preserveFilename) {
            this.preserveFilename(preserveFilename == null ? null : preserveFilename.toString());
            return this;
        }

        public final String getEnforceMessageSigning() {
            return this.enforceMessageSigning;
        }

        public final void setEnforceMessageSigning(String enforceMessageSigning) {
            this.enforceMessageSigning = enforceMessageSigning;
        }

        @Override
        public final Builder enforceMessageSigning(String enforceMessageSigning) {
            this.enforceMessageSigning = enforceMessageSigning;
            return this;
        }

        @Override
        public final Builder enforceMessageSigning(EnforceMessageSigningType enforceMessageSigning) {
            this.enforceMessageSigning(enforceMessageSigning == null ? null : enforceMessageSigning.toString());
            return this;
        }

        public final CustomDirectoriesType.Builder getCustomDirectories() {
            return this.customDirectories != null ? this.customDirectories.toBuilder() : null;
        }

        public final void setCustomDirectories(CustomDirectoriesType.BuilderImpl customDirectories) {
            this.customDirectories = customDirectories != null ? customDirectories.build() : null;
        }

        @Override
        public final Builder customDirectories(CustomDirectoriesType customDirectories) {
            this.customDirectories = customDirectories;
            return this;
        }

        public DescribedAgreement build() {
            return new DescribedAgreement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedAgreement> {
        public Builder arn(String var1);

        public Builder agreementId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(AgreementStatusType var1);

        public Builder serverId(String var1);

        public Builder localProfileId(String var1);

        public Builder partnerProfileId(String var1);

        public Builder baseDirectory(String var1);

        public Builder accessRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder preserveFilename(String var1);

        public Builder preserveFilename(PreserveFilenameType var1);

        public Builder enforceMessageSigning(String var1);

        public Builder enforceMessageSigning(EnforceMessageSigningType var1);

        public Builder customDirectories(CustomDirectoriesType var1);

        default public Builder customDirectories(Consumer<CustomDirectoriesType.Builder> customDirectories) {
            return this.customDirectories((CustomDirectoriesType)((CustomDirectoriesType.Builder)CustomDirectoriesType.builder().applyMutation(customDirectories)).build());
        }
    }
}

