/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRemoteMoveRequest extends TransferRequest implements
        ToCopyableBuilder<StartRemoteMoveRequest.Builder, StartRemoteMoveRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(StartRemoteMoveRequest::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePath").getter(getter(StartRemoteMoveRequest::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()).build();

    private static final SdkField<String> TARGET_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetPath").getter(getter(StartRemoteMoveRequest::targetPath)).setter(setter(Builder::targetPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            SOURCE_PATH_FIELD, TARGET_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorId;

    private final String sourcePath;

    private final String targetPath;

    private StartRemoteMoveRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.sourcePath = builder.sourcePath;
        this.targetPath = builder.targetPath;
    }

    /**
     * <p>
     * The unique identifier for the connector.
     * </p>
     * 
     * @return The unique identifier for the connector.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The absolute path of the file or directory to move or rename. You can only specify one path per call to this
     * operation.
     * </p>
     * 
     * @return The absolute path of the file or directory to move or rename. You can only specify one path per call to
     *         this operation.
     */
    public final String sourcePath() {
        return sourcePath;
    }

    /**
     * <p>
     * The absolute path for the target of the move/rename operation.
     * </p>
     * 
     * @return The absolute path for the target of the move/rename operation.
     */
    public final String targetPath() {
        return targetPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(targetPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRemoteMoveRequest)) {
            return false;
        }
        StartRemoteMoveRequest other = (StartRemoteMoveRequest) obj;
        return Objects.equals(connectorId(), other.connectorId()) && Objects.equals(sourcePath(), other.sourcePath())
                && Objects.equals(targetPath(), other.targetPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRemoteMoveRequest").add("ConnectorId", connectorId()).add("SourcePath", sourcePath())
                .add("TargetPath", targetPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "SourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        case "TargetPath":
            return Optional.ofNullable(clazz.cast(targetPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("SourcePath", SOURCE_PATH_FIELD);
        map.put("TargetPath", TARGET_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRemoteMoveRequest, T> g) {
        return obj -> g.apply((StartRemoteMoveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartRemoteMoveRequest> {
        /**
         * <p>
         * The unique identifier for the connector.
         * </p>
         * 
         * @param connectorId
         *        The unique identifier for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The absolute path of the file or directory to move or rename. You can only specify one path per call to this
         * operation.
         * </p>
         * 
         * @param sourcePath
         *        The absolute path of the file or directory to move or rename. You can only specify one path per call
         *        to this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);

        /**
         * <p>
         * The absolute path for the target of the move/rename operation.
         * </p>
         * 
         * @param targetPath
         *        The absolute path for the target of the move/rename operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPath(String targetPath);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String connectorId;

        private String sourcePath;

        private String targetPath;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRemoteMoveRequest model) {
            super(model);
            connectorId(model.connectorId);
            sourcePath(model.sourcePath);
            targetPath(model.targetPath);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final String getTargetPath() {
            return targetPath;
        }

        public final void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public final Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRemoteMoveRequest build() {
            return new StartRemoteMoveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
