/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the properties of the profile that was specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedProfile implements SdkPojo, Serializable, ToCopyableBuilder<ListedProfile.Builder, ListedProfile> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedProfile::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(ListedProfile::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> AS2_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("As2Id")
            .getter(getter(ListedProfile::as2Id)).setter(setter(Builder::as2Id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Id").build()).build();

    private static final SdkField<String> PROFILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileType").getter(getter(ListedProfile::profileTypeAsString)).setter(setter(Builder::profileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PROFILE_ID_FIELD,
            AS2_ID_FIELD, PROFILE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String profileId;

    private final String as2Id;

    private final String profileType;

    private ListedProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.profileId = builder.profileId;
        this.as2Id = builder.as2Id;
        this.profileType = builder.profileType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique identifier for the local or partner AS2 profile.
     * </p>
     * 
     * @return A unique identifier for the local or partner AS2 profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The <code>As2Id</code> is the <i>AS2-name</i>, as defined in the <a
     * href="https://datatracker.ietf.org/doc/html/rfc4130">RFC 4130</a>. For inbound transfers, this is the
     * <code>AS2-From</code> header for the AS2 messages sent from the partner. For outbound connectors, this is the
     * <code>AS2-To</code> header for the AS2 messages sent to the partner using the <code>StartFileTransfer</code> API
     * operation. This ID cannot include spaces.
     * </p>
     * 
     * @return The <code>As2Id</code> is the <i>AS2-name</i>, as defined in the <a
     *         href="https://datatracker.ietf.org/doc/html/rfc4130">RFC 4130</a>. For inbound transfers, this is the
     *         <code>AS2-From</code> header for the AS2 messages sent from the partner. For outbound connectors, this is
     *         the <code>AS2-To</code> header for the AS2 messages sent to the partner using the
     *         <code>StartFileTransfer</code> API operation. This ID cannot include spaces.
     */
    public final String as2Id() {
        return as2Id;
    }

    /**
     * <p>
     * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles. If
     * not supplied in the request, the command lists all types of profiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileType} will
     * return {@link ProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
     *         profiles. If not supplied in the request, the command lists all types of profiles.
     * @see ProfileType
     */
    public final ProfileType profileType() {
        return ProfileType.fromValue(profileType);
    }

    /**
     * <p>
     * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles. If
     * not supplied in the request, the command lists all types of profiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileType} will
     * return {@link ProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
     *         profiles. If not supplied in the request, the command lists all types of profiles.
     * @see ProfileType
     */
    public final String profileTypeAsString() {
        return profileType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(as2Id());
        hashCode = 31 * hashCode + Objects.hashCode(profileTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedProfile)) {
            return false;
        }
        ListedProfile other = (ListedProfile) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(as2Id(), other.as2Id()) && Objects.equals(profileTypeAsString(), other.profileTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedProfile").add("Arn", arn()).add("ProfileId", profileId()).add("As2Id", as2Id())
                .add("ProfileType", profileTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "As2Id":
            return Optional.ofNullable(clazz.cast(as2Id()));
        case "ProfileType":
            return Optional.ofNullable(clazz.cast(profileTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("As2Id", AS2_ID_FIELD);
        map.put("ProfileType", PROFILE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedProfile, T> g) {
        return obj -> g.apply((ListedProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedProfile> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the specified profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique identifier for the local or partner AS2 profile.
         * </p>
         * 
         * @param profileId
         *        A unique identifier for the local or partner AS2 profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The <code>As2Id</code> is the <i>AS2-name</i>, as defined in the <a
         * href="https://datatracker.ietf.org/doc/html/rfc4130">RFC 4130</a>. For inbound transfers, this is the
         * <code>AS2-From</code> header for the AS2 messages sent from the partner. For outbound connectors, this is the
         * <code>AS2-To</code> header for the AS2 messages sent to the partner using the <code>StartFileTransfer</code>
         * API operation. This ID cannot include spaces.
         * </p>
         * 
         * @param as2Id
         *        The <code>As2Id</code> is the <i>AS2-name</i>, as defined in the <a
         *        href="https://datatracker.ietf.org/doc/html/rfc4130">RFC 4130</a>. For inbound transfers, this is the
         *        <code>AS2-From</code> header for the AS2 messages sent from the partner. For outbound connectors, this
         *        is the <code>AS2-To</code> header for the AS2 messages sent to the partner using the
         *        <code>StartFileTransfer</code> API operation. This ID cannot include spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder as2Id(String as2Id);

        /**
         * <p>
         * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles.
         * If not supplied in the request, the command lists all types of profiles.
         * </p>
         * 
         * @param profileType
         *        Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
         *        profiles. If not supplied in the request, the command lists all types of profiles.
         * @see ProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileType
         */
        Builder profileType(String profileType);

        /**
         * <p>
         * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles.
         * If not supplied in the request, the command lists all types of profiles.
         * </p>
         * 
         * @param profileType
         *        Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
         *        profiles. If not supplied in the request, the command lists all types of profiles.
         * @see ProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileType
         */
        Builder profileType(ProfileType profileType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String profileId;

        private String as2Id;

        private String profileType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedProfile model) {
            arn(model.arn);
            profileId(model.profileId);
            as2Id(model.as2Id);
            profileType(model.profileType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getAs2Id() {
            return as2Id;
        }

        public final void setAs2Id(String as2Id) {
            this.as2Id = as2Id;
        }

        @Override
        public final Builder as2Id(String as2Id) {
            this.as2Id = as2Id;
            return this;
        }

        public final String getProfileType() {
            return profileType;
        }

        public final void setProfileType(String profileType) {
            this.profileType = profileType;
        }

        @Override
        public final Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        @Override
        public final Builder profileType(ProfileType profileType) {
            this.profileType(profileType == null ? null : profileType.toString());
            return this;
        }

        @Override
        public ListedProfile build() {
            return new ListedProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
