/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExecutionsResponse extends TransferResponse implements
        ToCopyableBuilder<ListExecutionsResponse.Builder, ListExecutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowId").getter(getter(ListExecutionsResponse::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()).build();

    private static final SdkField<List<ListedExecution>> EXECUTIONS_FIELD = SdkField
            .<List<ListedExecution>> builder(MarshallingType.LIST)
            .memberName("Executions")
            .getter(getter(ListExecutionsResponse::executions))
            .setter(setter(Builder::executions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Executions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKFLOW_ID_FIELD, EXECUTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final String workflowId;

    private final List<ListedExecution> executions;

    private ListExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workflowId = builder.workflowId;
        this.executions = builder.executions;
    }

    /**
     * <p>
     * <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the
     * <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.
     * </p>
     * 
     * @return <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass
     *         the <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A unique identifier for the workflow.
     * </p>
     * 
     * @return A unique identifier for the workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Executions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExecutions() {
        return executions != null && !(executions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the details for each execution, in a <code>ListedExecution</code> array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutions} method.
     * </p>
     * 
     * @return Returns the details for each execution, in a <code>ListedExecution</code> array.
     */
    public final List<ListedExecution> executions() {
        return executions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutions() ? executions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsResponse)) {
            return false;
        }
        ListExecutionsResponse other = (ListExecutionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(workflowId(), other.workflowId())
                && hasExecutions() == other.hasExecutions() && Objects.equals(executions(), other.executions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExecutionsResponse").add("NextToken", nextToken()).add("WorkflowId", workflowId())
                .add("Executions", hasExecutions() ? executions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WorkflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "Executions":
            return Optional.ofNullable(clazz.cast(executions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("Executions", EXECUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExecutionsResponse, T> g) {
        return obj -> g.apply((ListExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListExecutionsResponse> {
        /**
         * <p>
         * <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the
         * <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.
         * </p>
         * 
         * @param nextToken
         *        <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then
         *        pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional
         *        executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A unique identifier for the workflow.
         * </p>
         * 
         * @param workflowId
         *        A unique identifier for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * Returns the details for each execution, in a <code>ListedExecution</code> array.
         * </p>
         * 
         * @param executions
         *        Returns the details for each execution, in a <code>ListedExecution</code> array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executions(Collection<ListedExecution> executions);

        /**
         * <p>
         * Returns the details for each execution, in a <code>ListedExecution</code> array.
         * </p>
         * 
         * @param executions
         *        Returns the details for each execution, in a <code>ListedExecution</code> array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executions(ListedExecution... executions);

        /**
         * <p>
         * Returns the details for each execution, in a <code>ListedExecution</code> array.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ListedExecution.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.transfer.model.ListedExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ListedExecution.Builder#build()} is called immediately
         * and its result is passed to {@link #executions(List<ListedExecution>)}.
         * 
         * @param executions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ListedExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executions(java.util.Collection<ListedExecution>)
         */
        Builder executions(Consumer<ListedExecution.Builder>... executions);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String workflowId;

        private List<ListedExecution> executions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            workflowId(model.workflowId);
            executions(model.executions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final List<ListedExecution.Builder> getExecutions() {
            List<ListedExecution.Builder> result = ListedExecutionsCopier.copyToBuilder(this.executions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutions(Collection<ListedExecution.BuilderImpl> executions) {
            this.executions = ListedExecutionsCopier.copyFromBuilder(executions);
        }

        @Override
        public final Builder executions(Collection<ListedExecution> executions) {
            this.executions = ListedExecutionsCopier.copy(executions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executions(ListedExecution... executions) {
            executions(Arrays.asList(executions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executions(Consumer<ListedExecution.Builder>... executions) {
            executions(Stream.of(executions).map(c -> ListedExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListExecutionsResponse build() {
            return new ListExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
