/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of a certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribedCertificate.Builder, DescribedCertificate> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribedCertificate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateId").getter(getter(DescribedCertificate::certificateId))
            .setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<String> USAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Usage")
            .getter(getter(DescribedCertificate::usageAsString)).setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribedCertificate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Certificate").getter(getter(DescribedCertificate::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateChain").getter(getter(DescribedCertificate::certificateChain))
            .setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()).build();

    private static final SdkField<Instant> ACTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ActiveDate").getter(getter(DescribedCertificate::activeDate)).setter(setter(Builder::activeDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDate").build()).build();

    private static final SdkField<Instant> INACTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InactiveDate").getter(getter(DescribedCertificate::inactiveDate)).setter(setter(Builder::inactiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InactiveDate").build()).build();

    private static final SdkField<String> SERIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Serial")
            .getter(getter(DescribedCertificate::serial)).setter(setter(Builder::serial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serial").build()).build();

    private static final SdkField<Instant> NOT_BEFORE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NotBeforeDate").getter(getter(DescribedCertificate::notBeforeDate))
            .setter(setter(Builder::notBeforeDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBeforeDate").build()).build();

    private static final SdkField<Instant> NOT_AFTER_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NotAfterDate").getter(getter(DescribedCertificate::notAfterDate)).setter(setter(Builder::notAfterDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfterDate").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribedCertificate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribedCertificate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribedCertificate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CERTIFICATE_ID_FIELD, USAGE_FIELD, STATUS_FIELD, CERTIFICATE_FIELD, CERTIFICATE_CHAIN_FIELD, ACTIVE_DATE_FIELD,
            INACTIVE_DATE_FIELD, SERIAL_FIELD, NOT_BEFORE_DATE_FIELD, NOT_AFTER_DATE_FIELD, TYPE_FIELD, DESCRIPTION_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String certificateId;

    private final String usage;

    private final String status;

    private final String certificate;

    private final String certificateChain;

    private final Instant activeDate;

    private final Instant inactiveDate;

    private final String serial;

    private final Instant notBeforeDate;

    private final Instant notAfterDate;

    private final String type;

    private final String description;

    private final List<Tag> tags;

    private DescribedCertificate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateId = builder.certificateId;
        this.usage = builder.usage;
        this.status = builder.status;
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
        this.activeDate = builder.activeDate;
        this.inactiveDate = builder.inactiveDate;
        this.serial = builder.serial;
        this.notBeforeDate = builder.notBeforeDate;
        this.notAfterDate = builder.notAfterDate;
        this.type = builder.type;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) for the certificate.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) for the certificate.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An array of identifiers for the imported certificates. You use this identifier for working with profiles and
     * partner profiles.
     * </p>
     * 
     * @return An array of identifiers for the imported certificates. You use this identifier for working with profiles
     *         and partner profiles.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * Specifies how this certificate is used. It can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SIGNING</code>: For signing AS2 messages
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTION</code>: For encrypting AS2 messages
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TLS</code>: For securing AS2 communications sent over HTTPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usage} will return
     * {@link CertificateUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageAsString}.
     * </p>
     * 
     * @return Specifies how this certificate is used. It can be used in the following ways:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SIGNING</code>: For signing AS2 messages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTION</code>: For encrypting AS2 messages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TLS</code>: For securing AS2 communications sent over HTTPS
     *         </p>
     *         </li>
     * @see CertificateUsageType
     */
    public final CertificateUsageType usage() {
        return CertificateUsageType.fromValue(usage);
    }

    /**
     * <p>
     * Specifies how this certificate is used. It can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SIGNING</code>: For signing AS2 messages
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTION</code>: For encrypting AS2 messages
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TLS</code>: For securing AS2 communications sent over HTTPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usage} will return
     * {@link CertificateUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageAsString}.
     * </p>
     * 
     * @return Specifies how this certificate is used. It can be used in the following ways:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SIGNING</code>: For signing AS2 messages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTION</code>: For encrypting AS2 messages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TLS</code>: For securing AS2 communications sent over HTTPS
     *         </p>
     *         </li>
     * @see CertificateUsageType
     */
    public final String usageAsString() {
        return usage;
    }

    /**
     * <p>
     * A certificate's status can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * You can set <code>ActiveDate</code> and <code>InactiveDate</code> in the <code>UpdateCertificate</code> call. If
     * you set values for these parameters, those values are used to determine whether the certificate has a status of
     * <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If you don't set values for <code>ActiveDate</code> and <code>InactiveDate</code>, we use the
     * <code>NotBefore</code> and <code>NotAfter</code> date as specified on the X509 certificate to determine when a
     * certificate is active and when it is inactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A certificate's status can be either <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
     *         <p>
     *         You can set <code>ActiveDate</code> and <code>InactiveDate</code> in the <code>UpdateCertificate</code>
     *         call. If you set values for these parameters, those values are used to determine whether the certificate
     *         has a status of <code>ACTIVE</code> or <code>INACTIVE</code>.
     *         </p>
     *         <p>
     *         If you don't set values for <code>ActiveDate</code> and <code>InactiveDate</code>, we use the
     *         <code>NotBefore</code> and <code>NotAfter</code> date as specified on the X509 certificate to determine
     *         when a certificate is active and when it is inactive.
     * @see CertificateStatusType
     */
    public final CertificateStatusType status() {
        return CertificateStatusType.fromValue(status);
    }

    /**
     * <p>
     * A certificate's status can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * You can set <code>ActiveDate</code> and <code>InactiveDate</code> in the <code>UpdateCertificate</code> call. If
     * you set values for these parameters, those values are used to determine whether the certificate has a status of
     * <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If you don't set values for <code>ActiveDate</code> and <code>InactiveDate</code>, we use the
     * <code>NotBefore</code> and <code>NotAfter</code> date as specified on the X509 certificate to determine when a
     * certificate is active and when it is inactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A certificate's status can be either <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
     *         <p>
     *         You can set <code>ActiveDate</code> and <code>InactiveDate</code> in the <code>UpdateCertificate</code>
     *         call. If you set values for these parameters, those values are used to determine whether the certificate
     *         has a status of <code>ACTIVE</code> or <code>INACTIVE</code>.
     *         </p>
     *         <p>
     *         If you don't set values for <code>ActiveDate</code> and <code>InactiveDate</code>, we use the
     *         <code>NotBefore</code> and <code>NotAfter</code> date as specified on the X509 certificate to determine
     *         when a certificate is active and when it is inactive.
     * @see CertificateStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The file name for the certificate.
     * </p>
     * 
     * @return The file name for the certificate.
     */
    public final String certificate() {
        return certificate;
    }

    /**
     * <p>
     * The list of certificates that make up the chain for the certificate.
     * </p>
     * 
     * @return The list of certificates that make up the chain for the certificate.
     */
    public final String certificateChain() {
        return certificateChain;
    }

    /**
     * <p>
     * An optional date that specifies when the certificate becomes active. If you do not specify a value,
     * <code>ActiveDate</code> takes the same value as <code>NotBeforeDate</code>, which is specified by the CA.
     * </p>
     * 
     * @return An optional date that specifies when the certificate becomes active. If you do not specify a value,
     *         <code>ActiveDate</code> takes the same value as <code>NotBeforeDate</code>, which is specified by the CA.
     */
    public final Instant activeDate() {
        return activeDate;
    }

    /**
     * <p>
     * An optional date that specifies when the certificate becomes inactive. If you do not specify a value,
     * <code>InactiveDate</code> takes the same value as <code>NotAfterDate</code>, which is specified by the CA.
     * </p>
     * 
     * @return An optional date that specifies when the certificate becomes inactive. If you do not specify a value,
     *         <code>InactiveDate</code> takes the same value as <code>NotAfterDate</code>, which is specified by the
     *         CA.
     */
    public final Instant inactiveDate() {
        return inactiveDate;
    }

    /**
     * <p>
     * The serial number for the certificate.
     * </p>
     * 
     * @return The serial number for the certificate.
     */
    public final String serial() {
        return serial;
    }

    /**
     * <p>
     * The earliest date that the certificate is valid.
     * </p>
     * 
     * @return The earliest date that the certificate is valid.
     */
    public final Instant notBeforeDate() {
        return notBeforeDate;
    }

    /**
     * <p>
     * The final date that the certificate is valid.
     * </p>
     * 
     * @return The final date that the certificate is valid.
     */
    public final Instant notAfterDate() {
        return notAfterDate;
    }

    /**
     * <p>
     * If a private key has been specified for the certificate, its type is <code>CERTIFICATE_WITH_PRIVATE_KEY</code>.
     * If there is no private key, the type is <code>CERTIFICATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return If a private key has been specified for the certificate, its type is
     *         <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is
     *         <code>CERTIFICATE</code>.
     * @see CertificateType
     */
    public final CertificateType type() {
        return CertificateType.fromValue(type);
    }

    /**
     * <p>
     * If a private key has been specified for the certificate, its type is <code>CERTIFICATE_WITH_PRIVATE_KEY</code>.
     * If there is no private key, the type is <code>CERTIFICATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return If a private key has been specified for the certificate, its type is
     *         <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is
     *         <code>CERTIFICATE</code>.
     * @see CertificateType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name or description that's used to identity the certificate.
     * </p>
     * 
     * @return The name or description that's used to identity the certificate.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for certificates.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(usageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(activeDate());
        hashCode = 31 * hashCode + Objects.hashCode(inactiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(serial());
        hashCode = 31 * hashCode + Objects.hashCode(notBeforeDate());
        hashCode = 31 * hashCode + Objects.hashCode(notAfterDate());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedCertificate)) {
            return false;
        }
        DescribedCertificate other = (DescribedCertificate) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(usageAsString(), other.usageAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(certificate(), other.certificate())
                && Objects.equals(certificateChain(), other.certificateChain())
                && Objects.equals(activeDate(), other.activeDate()) && Objects.equals(inactiveDate(), other.inactiveDate())
                && Objects.equals(serial(), other.serial()) && Objects.equals(notBeforeDate(), other.notBeforeDate())
                && Objects.equals(notAfterDate(), other.notAfterDate()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedCertificate").add("Arn", arn()).add("CertificateId", certificateId())
                .add("Usage", usageAsString()).add("Status", statusAsString())
                .add("Certificate", certificate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CertificateChain", certificateChain() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ActiveDate", activeDate()).add("InactiveDate", inactiveDate()).add("Serial", serial())
                .add("NotBeforeDate", notBeforeDate()).add("NotAfterDate", notAfterDate()).add("Type", typeAsString())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "Usage":
            return Optional.ofNullable(clazz.cast(usageAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "CertificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        case "ActiveDate":
            return Optional.ofNullable(clazz.cast(activeDate()));
        case "InactiveDate":
            return Optional.ofNullable(clazz.cast(inactiveDate()));
        case "Serial":
            return Optional.ofNullable(clazz.cast(serial()));
        case "NotBeforeDate":
            return Optional.ofNullable(clazz.cast(notBeforeDate()));
        case "NotAfterDate":
            return Optional.ofNullable(clazz.cast(notAfterDate()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CertificateId", CERTIFICATE_ID_FIELD);
        map.put("Usage", USAGE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Certificate", CERTIFICATE_FIELD);
        map.put("CertificateChain", CERTIFICATE_CHAIN_FIELD);
        map.put("ActiveDate", ACTIVE_DATE_FIELD);
        map.put("InactiveDate", INACTIVE_DATE_FIELD);
        map.put("Serial", SERIAL_FIELD);
        map.put("NotBeforeDate", NOT_BEFORE_DATE_FIELD);
        map.put("NotAfterDate", NOT_AFTER_DATE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedCertificate, T> g) {
        return obj -> g.apply((DescribedCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedCertificate> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) for the certificate.
         * </p>
         * 
         * @param arn
         *        The unique Amazon Resource Name (ARN) for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An array of identifiers for the imported certificates. You use this identifier for working with profiles and
         * partner profiles.
         * </p>
         * 
         * @param certificateId
         *        An array of identifiers for the imported certificates. You use this identifier for working with
         *        profiles and partner profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * Specifies how this certificate is used. It can be used in the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SIGNING</code>: For signing AS2 messages
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTION</code>: For encrypting AS2 messages
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TLS</code>: For securing AS2 communications sent over HTTPS
         * </p>
         * </li>
         * </ul>
         * 
         * @param usage
         *        Specifies how this certificate is used. It can be used in the following ways:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SIGNING</code>: For signing AS2 messages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTION</code>: For encrypting AS2 messages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TLS</code>: For securing AS2 communications sent over HTTPS
         *        </p>
         *        </li>
         * @see CertificateUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateUsageType
         */
        Builder usage(String usage);

        /**
         * <p>
         * Specifies how this certificate is used. It can be used in the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SIGNING</code>: For signing AS2 messages
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTION</code>: For encrypting AS2 messages
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TLS</code>: For securing AS2 communications sent over HTTPS
         * </p>
         * </li>
         * </ul>
         * 
         * @param usage
         *        Specifies how this certificate is used. It can be used in the following ways:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SIGNING</code>: For signing AS2 messages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTION</code>: For encrypting AS2 messages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TLS</code>: For securing AS2 communications sent over HTTPS
         *        </p>
         *        </li>
         * @see CertificateUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateUsageType
         */
        Builder usage(CertificateUsageType usage);

        /**
         * <p>
         * A certificate's status can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * <p>
         * You can set <code>ActiveDate</code> and <code>InactiveDate</code> in the <code>UpdateCertificate</code> call.
         * If you set values for these parameters, those values are used to determine whether the certificate has a
         * status of <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * <p>
         * If you don't set values for <code>ActiveDate</code> and <code>InactiveDate</code>, we use the
         * <code>NotBefore</code> and <code>NotAfter</code> date as specified on the X509 certificate to determine when
         * a certificate is active and when it is inactive.
         * </p>
         * 
         * @param status
         *        A certificate's status can be either <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
         *        <p>
         *        You can set <code>ActiveDate</code> and <code>InactiveDate</code> in the
         *        <code>UpdateCertificate</code> call. If you set values for these parameters, those values are used to
         *        determine whether the certificate has a status of <code>ACTIVE</code> or <code>INACTIVE</code>.
         *        </p>
         *        <p>
         *        If you don't set values for <code>ActiveDate</code> and <code>InactiveDate</code>, we use the
         *        <code>NotBefore</code> and <code>NotAfter</code> date as specified on the X509 certificate to
         *        determine when a certificate is active and when it is inactive.
         * @see CertificateStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * A certificate's status can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * <p>
         * You can set <code>ActiveDate</code> and <code>InactiveDate</code> in the <code>UpdateCertificate</code> call.
         * If you set values for these parameters, those values are used to determine whether the certificate has a
         * status of <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * <p>
         * If you don't set values for <code>ActiveDate</code> and <code>InactiveDate</code>, we use the
         * <code>NotBefore</code> and <code>NotAfter</code> date as specified on the X509 certificate to determine when
         * a certificate is active and when it is inactive.
         * </p>
         * 
         * @param status
         *        A certificate's status can be either <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
         *        <p>
         *        You can set <code>ActiveDate</code> and <code>InactiveDate</code> in the
         *        <code>UpdateCertificate</code> call. If you set values for these parameters, those values are used to
         *        determine whether the certificate has a status of <code>ACTIVE</code> or <code>INACTIVE</code>.
         *        </p>
         *        <p>
         *        If you don't set values for <code>ActiveDate</code> and <code>InactiveDate</code>, we use the
         *        <code>NotBefore</code> and <code>NotAfter</code> date as specified on the X509 certificate to
         *        determine when a certificate is active and when it is inactive.
         * @see CertificateStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatusType
         */
        Builder status(CertificateStatusType status);

        /**
         * <p>
         * The file name for the certificate.
         * </p>
         * 
         * @param certificate
         *        The file name for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * The list of certificates that make up the chain for the certificate.
         * </p>
         * 
         * @param certificateChain
         *        The list of certificates that make up the chain for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(String certificateChain);

        /**
         * <p>
         * An optional date that specifies when the certificate becomes active. If you do not specify a value,
         * <code>ActiveDate</code> takes the same value as <code>NotBeforeDate</code>, which is specified by the CA.
         * </p>
         * 
         * @param activeDate
         *        An optional date that specifies when the certificate becomes active. If you do not specify a value,
         *        <code>ActiveDate</code> takes the same value as <code>NotBeforeDate</code>, which is specified by the
         *        CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDate(Instant activeDate);

        /**
         * <p>
         * An optional date that specifies when the certificate becomes inactive. If you do not specify a value,
         * <code>InactiveDate</code> takes the same value as <code>NotAfterDate</code>, which is specified by the CA.
         * </p>
         * 
         * @param inactiveDate
         *        An optional date that specifies when the certificate becomes inactive. If you do not specify a value,
         *        <code>InactiveDate</code> takes the same value as <code>NotAfterDate</code>, which is specified by the
         *        CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inactiveDate(Instant inactiveDate);

        /**
         * <p>
         * The serial number for the certificate.
         * </p>
         * 
         * @param serial
         *        The serial number for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serial(String serial);

        /**
         * <p>
         * The earliest date that the certificate is valid.
         * </p>
         * 
         * @param notBeforeDate
         *        The earliest date that the certificate is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBeforeDate(Instant notBeforeDate);

        /**
         * <p>
         * The final date that the certificate is valid.
         * </p>
         * 
         * @param notAfterDate
         *        The final date that the certificate is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAfterDate(Instant notAfterDate);

        /**
         * <p>
         * If a private key has been specified for the certificate, its type is
         * <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is <code>CERTIFICATE</code>.
         * </p>
         * 
         * @param type
         *        If a private key has been specified for the certificate, its type is
         *        <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is
         *        <code>CERTIFICATE</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(String type);

        /**
         * <p>
         * If a private key has been specified for the certificate, its type is
         * <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is <code>CERTIFICATE</code>.
         * </p>
         * 
         * @param type
         *        If a private key has been specified for the certificate, its type is
         *        <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is
         *        <code>CERTIFICATE</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(CertificateType type);

        /**
         * <p>
         * The name or description that's used to identity the certificate.
         * </p>
         * 
         * @param description
         *        The name or description that's used to identity the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for certificates.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for certificates.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for certificates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transfer.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String certificateId;

        private String usage;

        private String status;

        private String certificate;

        private String certificateChain;

        private Instant activeDate;

        private Instant inactiveDate;

        private String serial;

        private Instant notBeforeDate;

        private Instant notAfterDate;

        private String type;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedCertificate model) {
            arn(model.arn);
            certificateId(model.certificateId);
            usage(model.usage);
            status(model.status);
            certificate(model.certificate);
            certificateChain(model.certificateChain);
            activeDate(model.activeDate);
            inactiveDate(model.inactiveDate);
            serial(model.serial);
            notBeforeDate(model.notBeforeDate);
            notAfterDate(model.notAfterDate);
            type(model.type);
            description(model.description);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getUsage() {
            return usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public final Builder usage(CertificateUsageType usage) {
            this.usage(usage == null ? null : usage.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCertificate() {
            return certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateChain() {
            return certificateChain;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final Instant getActiveDate() {
            return activeDate;
        }

        public final void setActiveDate(Instant activeDate) {
            this.activeDate = activeDate;
        }

        @Override
        public final Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Instant getInactiveDate() {
            return inactiveDate;
        }

        public final void setInactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
        }

        @Override
        public final Builder inactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
            return this;
        }

        public final String getSerial() {
            return serial;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final Instant getNotBeforeDate() {
            return notBeforeDate;
        }

        public final void setNotBeforeDate(Instant notBeforeDate) {
            this.notBeforeDate = notBeforeDate;
        }

        @Override
        public final Builder notBeforeDate(Instant notBeforeDate) {
            this.notBeforeDate = notBeforeDate;
            return this;
        }

        public final Instant getNotAfterDate() {
            return notAfterDate;
        }

        public final void setNotAfterDate(Instant notAfterDate) {
            this.notAfterDate = notAfterDate;
        }

        @Override
        public final Builder notAfterDate(Instant notAfterDate) {
            this.notAfterDate = notAfterDate;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribedCertificate build() {
            return new DescribedCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
