/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.internal.UserAgentUtils;
import software.amazon.awssdk.services.transfer.model.ListAgreementsRequest;
import software.amazon.awssdk.services.transfer.model.ListAgreementsResponse;
import software.amazon.awssdk.services.transfer.model.ListedAgreement;

public class ListAgreementsIterable
implements SdkIterable<ListAgreementsResponse> {
    private final TransferClient client;
    private final ListAgreementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgreementsIterable(TransferClient client, ListAgreementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgreementsResponseFetcher();
    }

    public Iterator<ListAgreementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedAgreement> agreements() {
        Function<ListAgreementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agreements() != null) {
                return response.agreements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgreementsResponseFetcher
    implements SyncPageFetcher<ListAgreementsResponse> {
        private ListAgreementsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgreementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgreementsResponse nextPage(ListAgreementsResponse previousPage) {
            if (previousPage == null) {
                return ListAgreementsIterable.this.client.listAgreements(ListAgreementsIterable.this.firstRequest);
            }
            return ListAgreementsIterable.this.client.listAgreements((ListAgreementsRequest)((Object)ListAgreementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

