/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.internal.UserAgentUtils;
import software.amazon.awssdk.services.transfer.model.ListWebAppsRequest;
import software.amazon.awssdk.services.transfer.model.ListWebAppsResponse;
import software.amazon.awssdk.services.transfer.model.ListedWebApp;

public class ListWebAppsPublisher
implements SdkPublisher<ListWebAppsResponse> {
    private final TransferAsyncClient client;
    private final ListWebAppsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWebAppsPublisher(TransferAsyncClient client, ListWebAppsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWebAppsPublisher(TransferAsyncClient client, ListWebAppsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWebAppsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWebAppsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedWebApp> webApps() {
        Function<ListWebAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.webApps() != null) {
                return response.webApps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWebAppsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWebAppsResponseFetcher
    implements AsyncPageFetcher<ListWebAppsResponse> {
        private ListWebAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListWebAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWebAppsResponse> nextPage(ListWebAppsResponse previousPage) {
            if (previousPage == null) {
                return ListWebAppsPublisher.this.client.listWebApps(ListWebAppsPublisher.this.firstRequest);
            }
            return ListWebAppsPublisher.this.client.listWebApps((ListWebAppsRequest)((Object)ListWebAppsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

