/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.internal.UserAgentUtils;
import software.amazon.awssdk.services.transfer.model.ListWebAppsRequest;
import software.amazon.awssdk.services.transfer.model.ListWebAppsResponse;
import software.amazon.awssdk.services.transfer.model.ListedWebApp;

public class ListWebAppsIterable
implements SdkIterable<ListWebAppsResponse> {
    private final TransferClient client;
    private final ListWebAppsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWebAppsIterable(TransferClient client, ListWebAppsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWebAppsResponseFetcher();
    }

    public Iterator<ListWebAppsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedWebApp> webApps() {
        Function<ListWebAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.webApps() != null) {
                return response.webApps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWebAppsResponseFetcher
    implements SyncPageFetcher<ListWebAppsResponse> {
        private ListWebAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListWebAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWebAppsResponse nextPage(ListWebAppsResponse previousPage) {
            if (previousPage == null) {
                return ListWebAppsIterable.this.client.listWebApps(ListWebAppsIterable.this.firstRequest);
            }
            return ListWebAppsIterable.this.client.listWebApps((ListWebAppsRequest)((Object)ListWebAppsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

